<h2>{$service->lang['Used space statistics']}</h2>

<div id="last_30_days" style="width:100%; height:300px;"></div>
<hr>
<div id="avg_month" style="width:100%; height:300px;"></div>

<script>
    const diskHistory30 = [
        ['', '{$service->package_option_unit}'],
        {foreach from=$disk_history_30 key=h_key item=h_data}
        ['{$h_key}', {round($h_data.disk * $service->unit_coefficient, 3)}],
        {/foreach}
    ];

    const diskHistoryAvg = [
        ['', '{$service->package_option_unit}'],
        {foreach from=$disk_history key=h_key item=h_data}
        ['{$h_key}', {round($h_data.disk * $service->unit_coefficient, 3)}],
        {/foreach}
    ];
</script>

{literal}
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    google.charts.load('current', {packages: ['corechart']});
    google.charts.setOnLoadCallback(drawCharts);

    function drawCharts() {
        drawChart('last_30_days', diskHistory30, '{/literal}{$service->lang['Last 30 days']}{literal}');
        drawChart('avg_month', diskHistoryAvg, '{/literal}{$service->lang['Avg per month']}{literal}');
    }

    function drawChart(containerId, chartData, title) {
        const data = google.visualization.arrayToDataTable(chartData);

        const options = {
            title: title,
            legend: 'none',
            chartArea: {
                height: '60%',
                width: '85%'
            },
            height: 300,
            vAxis: {
                minValue: 0
            }
        };

        const chart = new google.visualization.ColumnChart(document.getElementById(containerId));
        chart.draw(data, options);
    }
</script>
{/literal}
