<style>
    .month-range {
        display: flex;
        align-items: center;
    }
    .month-range select {
        margin-right: 10px;
    }

    .puq-a-toggle,
    .puq-a-toggle:active {
        position: absolute;
        top: -5000px;
        height: 0;
        width: 0;
        opacity: 0;
        border: none;
        outline: none;
    }

    .checkbox-label {
        display: block;
        position: relative;
        padding: 10px;
        font-size: 12px;
        line-height: 16px;
        width: 100%;
        height: 28px;
        border-radius: 18px;
        background: #f8f8f8;
        cursor: pointer;
    }

    .checkbox-label:before {
        content: '';
        display: block;
        position: absolute;
        z-index: 1;
        line-height: 26px;
        text-indent: 32px;
        height: 28px;
        width: 28px;
        border-radius: 100%;
        top: 0px;
        left: 0px;
        right: auto;
        background: white;
        box-shadow: 0 3px 3px rgba(0,0,0,.2), 0 0 0 2px #dddddd;
        transition: all 1s ease-in-out;
        white-space: nowrap;
    }

    .checkbox-label:after {
        content: '';
        display: block;
        position: absolute;
        z-index: 0;
        top: 0;
        left: 0px;
        padding: 0px;
        height: 100%;
        width: 0px;
        text-align: right;
        color: #bfbfbf;
        white-space: nowrap;
        transition: all 1s ease-in-out;
    }

    .puq-a-toggle:checked + .checkbox-label {
        box-shadow: inset 0 0 0 20px rgba(19,191,17,1), 0 0 0 2px rgba(19,191,17,1);
    }
    #hide_no_traffic_days:checked + .checkbox-label:before {
        transition: all 1s ease-in-out;
        content: '';
    }
    .puq-a-toggle:checked + .checkbox-label:before {
        left: calc(100% - 28px);
        box-shadow: 0 0 0 2px transparent, 0 3px 3px rgba(0,0,0,.3);
    }

    .puq-a-toggle:checked + .checkbox-label:after {
        content: attr(data-on);
        left: 60px;
        width: 28px;
    }

    #hide_no_traffic_days:checked + .checkbox-label:after {
        color: rgba(19,191,17,1);
        transition: all 0.3s ease-in-out;
        content: '';
    }

    .label-text {
        position: absolute;
        top: 0;
        width: calc(100% - 60px);
        line-height: 28px;
        transition: opacity 1.2s;
    }

    .puq-a-toggle + .checkbox-label .off {
        left: 60px;
        text-align: left;
    }

    .puq-a-toggle:checked + .checkbox-label .off {
        opacity: 0;
    }

    .puq-a-toggle + .checkbox-label .on {
        right: 60px;
        text-align: right;
        opacity: 0;
    }

    .puq-a-toggle:checked + .checkbox-label .on {
        opacity: 1;
    }

    .puq-container {
        display: flex;
        flex-direction: row;
        align-items: stretch;
        width: 100%;
        flex-wrap: wrap;
    }

    .input-area, .toggle-area {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
    }

    .toggle-area {
        flex-grow: 1;
    }

    @media (min-width: 600px) {
        .input-area {
            width: auto;
        }
        .toggle-area {
            width: auto;
        }
    }

    @media (max-width: 599px) {
        .toggle-area {
            margin-top: 10px;
        }
    }


    .month-range > div {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .arrow {
        display: inline-block;
        width: 0;
        height: 0;
        margin-left: 5px;
    }

    .arrow.asc {
        border-top: 5px solid;
        border-left: 5px solid transparent;
        border-right: 5px solid transparent;
    }

    .arrow.desc {
        border-bottom: 5px solid;
        border-left: 5px solid transparent;
        border-right: 5px solid transparent;
    }

    .sortable {
        cursor: pointer;
    }

</style>
<h1>{$service->lang['Traffic statistics']}</h1>
<div class="puq-container">
    <div class="input-area">
        <form method="post">
            <div class="month-range">
                <div>
                    <label for="start_month">{$service->lang['Month']}:</label>
                    <select id="start_month" name="start_month" required>
                        {assign var="selectedYear" value=$post['start_year']|default:$currentYear}
                        {foreach $yearMonthArray[$selectedYear] as $monthName => $monthNumber}
                            <option value="{$monthNumber}" {if $monthNumber == ($post['start_month']|default:$currentMonth)}selected{/if}>{$service->lang[$monthName]}</option>
                        {/foreach}
                    </select>
                </div>
                <div>
                    <label for="start_year">{$service->lang['Year']}:</label>
                    <select id="start_year" name="start_year" required>
                        {foreach $yearMonthArray as $year => $months}
                            <option value="{$year}" {if $year == $selectedYear}selected{/if}>{$year}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </form>
    </div>
    <div class="toggle-area">
        <input type="checkbox" id="hide_no_traffic_days" name="hide_no_traffic_days" class="puq-a-toggle"/>
        <label for="hide_no_traffic_days" class="checkbox-label" data-off="off" data-on="on">
            <span class="label-text off">{$service->lang['Hide days with no traffic']}</span>
            <span class="label-text on">{$service->lang['Show days with no traffic']}</span>
        </label>
    </div>
</div>

<div id="last_30_days" style="width:100%; height:300px;"></div>
<hr>
<div class="card card-accent-blue panel panel-default panel-accent-blue">
    <table style="width:100%" class="table" id="table">
        <thead>
        <tr>
            <th id="date" class="sortable sorting_asc"><b>{$service->lang['Date']}</b> <span class="arrow asc"></span></th>
            <th id="download" class="sortable sorting_asc"><b>{$service->lang['Download']}</b> <span class="arrow"></span></th>
            <th id="upload" class="sortable sorting_asc"><b>{$service->lang['Upload']}</b> <span class="arrow"></span></th>
        </tr>
        </thead>
        <tbody id="traffic_data_body">
        {foreach $trafficStatistics as $dayData}
            <tr>
                <td class="date-column">{$dayData.date}</td>
                <td class="size-column">{$service->QuotaToGBorMB($dayData.traffic_download)}</td>
                <td class="size-column">{$service->QuotaToGBorMB($dayData.traffic_upload)}</td>
            </tr>
        {/foreach}
        </tbody>
    </table>
</div>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    const startMonthElement = document.getElementById('start_month');
    const startYearElement = document.getElementById('start_year');
    const trafficDataBody = document.getElementById('traffic_data_body');
    const hideNoTrafficDaysElement = document.getElementById('hide_no_traffic_days');
    let last30DaysChart;
    let currentData;
    startMonthElement.value = '{$currentMonth}';
    startYearElement.value = '{$currentYear}';

    [startMonthElement, startYearElement].forEach(el => el.addEventListener('change', loadAndDrawData));

    hideNoTrafficDaysElement.addEventListener('change', loadAndDrawData);

    function convertToBytes(value) {
        var bytes = 0;
        var num = parseFloat(value);
        if (value.includes('GB')) {
            bytes = num * 1024 * 1024 * 1024;
        } else if (value.includes('MB')) {
            bytes = num * 1024 * 1024;
        } else if (value.includes('KB')) {
            bytes = num * 1024;
        } else if (value.includes('bytes')) {
            bytes = num;
        }
        return bytes;
    }

    $(document).ready(function() {
        var tbody = $('#traffic_data_body');

        $('.sortable').click(function() {
            var rows = tbody.find('tr').toArray();
            var index = $(this).index();
            this.asc = !this.asc;

            if (this.id === 'date') {
                rows.sort(function(a, b) {
                    var valA = new Date(getCellValue(a, index));
                    var valB = new Date(getCellValue(b, index));
                    return (valA - valB) * (this.asc ? -1 : 1);
                }.bind(this));
            } else {
                rows.sort(function(a, b) {
                    var valA = convertToBytes(getCellValue(a, index));
                    var valB = convertToBytes(getCellValue(b, index));
                    if (valA === valB) {
                        return 0;
                    } else {
                        return (valA - valB) * (this.asc ? -1 : 1);
                    }
                }.bind(this));
            }

            tbody.append(rows);

            $('.sortable').find('.arrow').css('opacity', 0);

            $(this).find('.arrow').css('opacity', 1).toggleClass('asc', !this.asc).toggleClass('desc', this.asc);
        });

        function getCellValue(row, index) {
            return $(row).children('td').eq(index).text();
        }
    });


    window.onload = function() {
        const startMonthElement = document.getElementById('start_month');
        const startYearElement = document.getElementById('start_year');

        if (!startYearElement.value) {
            const today = new Date();
            startMonthElement.value = (today.getMonth() + 1).toString().padStart(2, '0');
            startYearElement.value = today.getFullYear().toString();
        }
    }

    hideNoTrafficDaysElement.addEventListener('change', function() {
        const hideNoTrafficDays = hideNoTrafficDaysElement.checked;
        const allRows = trafficDataBody.querySelectorAll('tr');
        allRows.forEach(row => {
            const download = row.children[1].innerText;
            const upload = row.children[2].innerText;
            if ((download === '0 bytes' || download === '0.00 KB' || download === '0.00 MB' || download === '0.00 GB') &&
                (upload === '0 bytes' || upload === '0.00 KB' || upload === '0.00 MB' || upload === '0.00 GB')) {
                if (hideNoTrafficDays) {
                    row.style.display = 'none';
                } else {
                    row.style.display = 'table-row';
                }
            }
        });
    });

    function loadAndDrawData() {
        const startMonth = startMonthElement.value;
        const startYear = startYearElement.value;
        const xhr = new XMLHttpRequest();
        xhr.open('POST', '{$service->BeforePath()}clientarea.php?action=productdetails&id={$get['id']}&action_m=traffic_statistics_month');
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (xhr.status === 200) {
                const response = JSON.parse(xhr.responseText);
                drawTableData(response);
                const chartData = extractChartData(response);
                drawCharts(chartData);
            }
        };
        xhr.send('start_month=' + startMonth + '&start_year=' + startYear);
    }
    function updateRowVisibility() {
        const hideNoTrafficDays = hideNoTrafficDaysElement.checked;
        const allRows = trafficDataBody.querySelectorAll('tr');
        allRows.forEach(row => {
            const download = row.children[1].innerText;
            const upload = row.children[2].innerText;
            if ((download === '0 bytes' || download === '0.00 KB' || download === '0.00 MB' || download === '0.00 GB') &&
                (upload === '0 bytes' || upload === '0.00 KB' || upload === '0.00 MB' || upload === '0.00 GB')) {
                if (hideNoTrafficDays) {
                    row.style.display = 'none';
                } else {
                    row.style.display = 'table-row';
                }
            }
        });
    }

    function drawTableData(data) {
        trafficDataBody.innerHTML = '';
        data.forEach(function(dayData) {
            trafficDataBody.innerHTML += `
<tr>
    <td>${ dayData.date }</td>
    <td>${ quotaCountWork(dayData.traffic_download) }</td>
    <td>${ quotaCountWork(dayData.traffic_upload) }</td>
</tr>`;
        });
        updateRowVisibility();
    }

    hideNoTrafficDaysElement.addEventListener('change', updateRowVisibility);

    function extractChartData(data) {
        const last30DaysData = [];

        let maxValue = 0;
        data.forEach(function(dayData) {
            const download = Number(dayData.traffic_download);
            const upload = Number(dayData.traffic_upload);

            maxValue = Math.max(maxValue, download, upload);
        });

        const unit = getUnit(maxValue);

        data.forEach(function(dayData) {
            const dateParts = dayData.date.split("-");
            const date = new Date(Date.UTC(dateParts[0], dateParts[1] - 1, dateParts[2])).toISOString().slice(0,10);
            const download = convertToUnit(Number(dayData.traffic_download), unit);
            const upload = convertToUnit(Number(dayData.traffic_upload), unit);

            last30DaysData.push([date, download, upload]);
        });

        return {
            last_30_days: last30DaysData,
            unit: unit
        };
    }

    function getUnit(valueInBytes) {
        if (valueInBytes >= Math.pow(1024, 3)) {
            return "GB";
        } else if (valueInBytes >= Math.pow(1024, 2)) {
            return "MB";
        } else if (valueInBytes >= 1024) {
            return "KB";
        } else {
            return "bytes";
        }
    }

    function convertToUnit(valueInBytes, unit) {
        switch (unit) {
            case "GB":
                return parseFloat((valueInBytes / Math.pow(1024, 3)).toFixed(2));
            case "MB":
                return parseFloat((valueInBytes / Math.pow(1024, 2)).toFixed(2));
            case "KB":
                return parseFloat((valueInBytes / 1024).toFixed(2));
            default:
                return valueInBytes;
        }
    }

    google.charts.load('current', { 'packages':['corechart'] });
    google.charts.setOnLoadCallback(loadAndDrawData);

    function drawCharts(data) {
        currentData = data;
        const options = {
            title: '{$service->lang['Traffic statistics for the selected period']}',
            legend: { position: 'top' },
            chartArea: {
                height: '45%',
                width: '85%'
            },
            height: '90%',
            width: '90%',
            vAxis: {
                title: '{$service->lang['Traffic']} (' + data.unit + ')',
                format: 'short',
            },
            hAxis: {
                title: '{$service->lang['Date']}',
                ticks: data.last_30_days.map(dayData => new Date(dayData[0])),
                slantedText: true,
                slantedTextAngle: 45 // Настройте угол, если необходимо
            },
            animation: {
                duration: 1000,
                easing: 'out',
                startup: true,
            }
        };

        const dataTable = new google.visualization.DataTable();
        dataTable.addColumn('string', 'Date');
        dataTable.addColumn('number', '{$service->lang['Download']} ' + '(' + data.unit + ')');
        dataTable.addColumn('number', '{$service->lang['Upload']} ' + '(' + data.unit + ')');

        data.last_30_days.forEach(dayData => {
            if (!hideNoTrafficDaysElement.checked || dayData[1] > 0 || dayData[2] > 0) {
                dataTable.addRow([dayData[0], dayData[1], dayData[2]]);
            }
        });

        last30DaysChart = new google.visualization.ColumnChart(document.getElementById('last_30_days'));
        last30DaysChart.draw(dataTable, options);
    }

    window.addEventListener('resize', function() {
        drawCharts(currentData);
    });

    startYearElement.addEventListener('change', function() {
        const year = startYearElement.value;
        const xhr = new XMLHttpRequest();
        xhr.open('POST', '{$service->BeforePath()}clientarea.php?action=productdetails&id={$get['id']}&action_m=traffic_statistics_month');
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (xhr.status === 200) {
                const months = JSON.parse(xhr.responseText);
                updateMonthSelect(months);
            }
        };
        xhr.send('year=' + year + '&get_months=true');
    });

    function updateMonthSelect(months) {
        startMonthElement.innerHTML = '';
        for (let monthName in months) {
            const monthNumber = months[monthName];
            startMonthElement.innerHTML += `<option value="${ monthNumber }">${ monthName }</option>`;
        }
    }

    function quotaCountWork(valueInBytes) {
        if (valueInBytes >= 1024 && valueInBytes < Math.pow(1024, 2)) {
            return (valueInBytes / 1024).toFixed(2) + " KB";
        } else if (valueInBytes >= Math.pow(1024, 2) && valueInBytes < Math.pow(1024, 3)) {
            return (valueInBytes / Math.pow(1024, 2)).toFixed(2) + " MB";
        } else if (valueInBytes >= Math.pow(1024, 3)) {
            return (valueInBytes / Math.pow(1024, 3)).toFixed(2) + " GB";
        } else {
            return valueInBytes + " bytes";
        }
    }
</script>
