{include file='modules/servers/puqProxmoxKVM/templates/header.tpl'}

<div class="form-group text-center">
    <h1>{$kvm->lang['Snapshots']}: {$snapshots_count}</h1>
</div>
{if $message eq 'success'}
    <div class="alert alert-success text-center">{$kvm->lang['Successfully']}</div>
{/if}
{if $message ne 'success' && $message ne ''}
    <div class="alert alert-danger text-center">{$message}</div>
{/if}
<div {$kvm->vm_local_status_html_inactive}>
<form method="post" action="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=snapshots">
    <div class="form-group text-center">
        <label for="snapshot_description">{$kvm->lang['Snapshot description']}</label>
        <input id="snapshot_description" type="input" name="snapshot_description" class="form-control"/ required><br>
        <button onclick="return TakeSnapshot();" type="submit" class="btn btn-success"><i class="fa fa-camera">&nbsp;</i>{$kvm->lang['Take Snapshot']}</button>
    </div>
</form>

<table class="table table-list dataTable no-footer">
    <tbody>
    {foreach from=$kvm->vm_remote_snapshots key=key item=snapshot}
        <tr>
            <td><i class="fa fa-camera fa-2x"></i></td>
            <td><b>{$snapshot['description']}</b> ({$snapshot['snaptime']})
                <br>{$kvm->lang['Will be automatically removed after']}: <b style="color: red">{$snapshot['removed_after']}</b></td>
            <td><a onclick="return ButtonRollback();" href="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=snapshots&rollback={$snapshot['name']}" class="btn btn-warning btn-sm"><i class="fa fa-reply">&nbsp;</i>{$kvm->lang['Rollback']}</td>
            <td><a onclick="return ButtonRemove();" href="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=snapshots&remove={$snapshot['name']}" class="btn btn-danger btn-sm"><i class="fa fa-trash">&nbsp;</i>{$kvm->lang['Remove']}</td>
        </tr>
    {/foreach}
    </tbody>
</table>
</div>
<script type="text/javascript">
    function ButtonRemove(){
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }

    function ButtonRollback(){
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }

    function TakeSnapshot() {
        var snapshot_description = document.getElementById('snapshot_description').value;
        if(snapshot_description === ''){
            return true;
        }
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }
</script>