<h5>{$kvm->lang['Network configuration']}</h5>
{if $kvm->service_count_ipv4 ne '0'}
    <div class="form-group" style="text-align: left;">
        <details>
            <summary>
                {if $kvm->package_options['network_configuration']['dhcp_ipv4'] ne 'on'}
                    <i class="fa fa-network-wired fa-1x"></i><b> IPv4: {$kvm->service_dedicatedip}/{$kvm->vm_local_net0_netmask} ({$kvm->service_domain})</b>
                {else}
                    <i class="fa fa-network-wired fa-1x"></i><b> IPv4: DHCP</b>
                {/if}
            </summary>
            {if $kvm->package_options['network_configuration']['dhcp_ipv4'] ne 'on'}
                <table class="table table-list dataTable no-footer">
                    <tr>
                        <td><b>{$kvm->lang['IP']}</b></td>
                        <td>
                            {$kvm->service_dedicatedip}/{$kvm->vm_local_net0_netmask}
                            {foreach $kvm->service_assignedips as $value}
                                <br>{$value}/{$kvm->vm_local_net0_netmask}
                            {/foreach}
                        </td>
                    </tr>
                    <tr>
                        <td><b>{$kvm->lang['GW']}</b></td>
                        <td>{$kvm->vm_local_net0_gateway}</td>
                    </tr>
                    <tr>
                        <td><b>{$kvm->lang['DNS']}</b></td>
                        <td>
                            {$array = explode(",", $kvm->vm_local_net0_dns)}
                            {foreach $array as $value}
                                {$value}<br>
                            {/foreach}
                        </td>
                    </tr>
                </table>
            {else}
                DHCP
            {/if}
        </details>
    </div>
{/if}

{if $kvm->service_count_ipv6 ne '0'}
    <div class="form-group" style="text-align: left;">
        <details>
            <summary>
                {if $kvm->package_options['network_configuration']['dhcp_ipv6'] ne 'on'}
                    <i class="fa fa-network-wired fa-1x"></i><b> IPv6: {$kvm->service_dedicatedip_ipv6}/{$kvm->vm_local_net0_netmask_ipv6} ({$kvm->service_domain})</b>
                {else}
                    <i class="fa fa-network-wired fa-1x"></i><b> IPv6: DHCP</b>
                {/if}
            </summary>
            {if $kvm->package_options['network_configuration']['dhcp_ipv6'] ne 'on'}
                <table class="table table-list dataTable no-footer">
                    <tr>
                        <td><b>{$kvm->lang['IP']}</b></td>
                        <td>
                            {foreach $kvm->service_assignedips_ipv6 as $value}
                                {$value}/{$kvm->vm_local_net0_netmask_ipv6}<br>
                            {/foreach}
                        </td>
                    </tr>
                    <tr>
                        <td><b>{$kvm->lang['GW']}</b></td>
                        <td>{$kvm->vm_local_net0_gateway_ipv6}</td>
                    </tr>
                    <tr>
                        <td><b>{$kvm->lang['DNS']}</b></td>
                        <td>
                            {$array = explode(",", $kvm->vm_local_net0_dns_ipv6)}
                            {foreach $array as $value}
                                {$value}<br>
                            {/foreach}
                        </td>
                    </tr>
                </table>
            {else}
                DHCP
            {/if}
        </details>
    </div>
{/if}