{include file='modules/servers/puqProxmoxKVM/templates/header.tpl'}

<div class="form-group text-center">
    <h1>{$kvm->lang['Backups']}: {$backups_count}</h1>
</div>
{if $message eq 'success'}
    <div class="alert alert-success text-center">{$kvm->lang['Successfully']}</div>
{/if}
{if $message ne 'success' && $message ne ''}
    <div class="alert alert-danger text-center">{$message}</div>
{/if}

<div {$kvm->vm_local_status_html_inactive}>
    <div class="form-group text-center">
        <form method="post" action="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=backups">
            <table class="table">
                <input type="text" name="schedule[submit]" value="1" hidden>
                <tr>
                    <th>{$kvm->lang['Sunday']}</th>
                    {if $kvm->vm_local_backup_schedule[0]}
                        <th><input type="checkbox" name="schedule[0]" value="0" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[0]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[0]" value="0"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Monday']}</th>
                    {if $kvm->vm_local_backup_schedule[1]}
                        <th><input type="checkbox" name="schedule[1]" value="0" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[1]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[1]" value="1"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Tuesday']}</th>
                    {if $kvm->vm_local_backup_schedule[2]}
                        <th><input type="checkbox" name="schedule[2]" value="2" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[2]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[2]" value="2"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Wednesday']}</th>
                    {if $kvm->vm_local_backup_schedule[3]}
                        <th><input type="checkbox" name="schedule[3]" value="3" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[3]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[3]" value="3"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Thursday']}</th>
                    {if $kvm->vm_local_backup_schedule[4]}
                        <th><input type="checkbox" name="schedule[4]" value="4" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[4]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[4]" value="4"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Friday']}</th>
                    {if $kvm->vm_local_backup_schedule[5]}
                        <th><input type="checkbox" name="schedule[5]" value="5" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[5]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[5]" value="5"></th>
                        <th></th>
                    {/if}
                </tr>
                <tr>
                    <th>{$kvm->lang['Saturday']}</th>
                    {if $kvm->vm_local_backup_schedule[6]}
                        <th><input type="checkbox" name="schedule[6]" value="6" checked></th>
                        <th>({$kvm->vm_local_backup_schedule[6]})</th>
                    {else}
                        <th><input type="checkbox" name="schedule[6]" value="6"></th>
                        <th></th>
                    {/if}
                </tr>
            </table>
            <i>{$kvm->lang['If the schedule is configured, the system will automatically create backups and delete old backups.']}</i><br>
            <i>{$kvm->lang['On this screen, you can configure the settings related to the backup schedule. Note that the settings on this screen affect which copies will be restored. If you have 3 available backups, setting a daily backup schedule will make the oldest backup you can recover from 3 days ago. If, on the other hand, you set the schedule for one day a week, then with 3 backup spaces, the oldest backup will be 3 weeks old. Take a moment to do this and think about what will be best for you.']}</i>
            <br>
            <button onclick="return BackupNow();" type="submit" class="btn btn-success"><i class="fas fa-pencil-alt">&nbsp;</i>{$kvm->lang['Save Schedule']}</button>


        </form>
    </div>
    <hr>
    <form method="post" action="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=backups">
        <div class="form-group text-center">
            <label for="backups_notes">{$kvm->lang['Backups notes']}</label>
            <input id="backups_notes" type="input" name="backups_notes" class="form-control"/ required><br>
            <button onclick="return BackupNow();" type="submit" class="btn btn-success"><i class="fa fa-clone">&nbsp;</i>{$kvm->lang['Backup now']}</button>
        </div>
    </form>
    <i class="fa fa-info">&nbsp;</i><i>{$kvm->lang['In the case of a backup restore, all snapshots of Virtual Machine will be deleted']}</i>
    <table class="table table-list dataTable no-footer">
        <tbody>
        {foreach from=$kvm->vm_remote_backups key=key item=backup}
            <tr>
                <td><i class="fa fa-clone fa-2x"></i></td>
                <td><b>{$backup['time']}</b><br>{$backup['notes']}</td>
                <td><a onclick="return ButtonRestore();" href="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=backups&restore={$backup['volid']|urlencode}" class="btn btn-warning btn-sm"><i class="fa fa-reply-all">&nbsp;</i>{$kvm->lang['Restore']}</td>
                <td><a onclick="return ButtonRemove();" href="/clientarea.php?action=productdetails&id={$kvm->service_id}&action_m=backups&remove={$backup['volid']|urlencode}" class="btn btn-danger btn-sm"><i class="fa fa-trash">&nbsp;</i>{$kvm->lang['Remove']}</td>
            </tr>
        {/foreach}
        </tbody>
    </table>
</div>


<script type="text/javascript">
    function ButtonRemove(){
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }

    function ButtonRestore(){
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }

    function BackupNow() {
        var snapshot_description = document.getElementById('backups_notes').value;
        if(snapshot_description === ''){
            return true;
        }
        result = confirm('{$kvm->lang['Are you sure?']}');
        if (result) {
            loading();
            return true
        }else {
            return false;
        }
    }
</script>
