{if $service->user_limited}
    <div class="alert alert-danger text-center">
        {$service->lang['The service is limited.']}
        <br>
        {$service->lang['Contact technical support.']}
    </div>
{/if}

{literal}
    <style>
        .hostbtn {
            width: 150px;
            min-width: 150px;
            padding: 10px 15px;
            background: #eee;
            display: inline-block;
            margin: 5px;
            vertical-align: top;
            border-radius: 3px;
            font-weight: 600;
            text-align: center;
            font-size: 14px;
            transition: transform 0.2s;
        }

        .hostbtn i {
            margin-right: 0;
            display: block;
            font-size: 24px;
            margin-bottom: 10px;
            transition: transform 0.2s;
        }

        .hostbtn:hover {
            background: #dbdbdb;
        }

        .hostbtn:hover i {
            transform: scale(1.2); /* Enlarge icon on hover */
        }
    </style>
{/literal}

<div class="d-flex justify-content-center flex-wrap">
    {if $service->package_option_link_to_instruction ne ''}
        <a href="{$service->package_option_link_to_instruction}" target="_blank" class="hostbtn">
            <i class="fas fa-book"></i> {$service->lang['User manual']}
        </a>
    {/if}
</div>

<div class="row border-bottom">
    <div class="col-md-4 d-flex">
        <b><i class="fa fa-server"></i>&nbsp;&nbsp;{$service->lang['Web interface address']}:</b>
    </div>
    <div class="col-md-8" style="word-break: break-all;">
        {if $service->server_httpprefix == 'https'}
            {if $service->server_port == '443'}
                <h3>
                    <a href="{$service->server_httpprefix}://{$service->server_hostname}/" target="_blank">
                        {$service->server_httpprefix}://{$service->server_hostname}/
                    </a>
                </h3>
            {else}
                <h3>
                    <a href="{$service->server_httpprefix}://{$service->server_hostname}:{$service->server_port}/"
                       target="_blank">
                        {$service->server_httpprefix}://{$service->server_hostname}:{$service->server_port}/
                    </a>
                </h3>
            {/if}
        {else}
            {if $service->server_port == '80'}
                <h3>
                    <a href="{$service->server_httpprefix}://{$service->server_hostname}/" target="_blank">
                        {$service->server_httpprefix}://{$service->server_hostname}/
                    </a>
                </h3>
            {else}
                <h3>
                    <a href="{$service->server_httpprefix}://{$service->server_hostname}:{$service->server_port}/"
                       target="_blank">
                        {$service->server_httpprefix}://{$service->server_hostname}:{$service->server_port}/
                    </a>
                </h3>
            {/if}
        {/if}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fa fa-user"></i>&nbsp;&nbsp;{$service->lang['Username']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <strong>{$service->service_username}</strong>
            </div>
            <div class="col-2 d-flex align-items-center">
                <div class="form-group mb-2 mt-2">
                    <div class="input-group">
                        <input type="hidden" name="username" id="username" value="{$service->service_username}">
                        <button onclick="copyUsername()" id="copyUsernameButton" class="btn btn-outline-danger"
                                type="button">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{if $service->package_option_show_password != 'no'}
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fa fa-lock"></i>&nbsp;&nbsp;{$service->lang['Password']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center">
                {if $service->package_option_show_password == 'show_button'}
                    <div class="form-group mb-2 mt-2 w-100">
                        <div class="input-group">
                            <input type="password" id="password" name="password" class="form-control"
                                   value="{$service->service_password}" disabled>
                            <div class="input-group-append">
                                <button id="showPasswordButton" class="btn btn-outline-secondary" type="button">
                                    <i class="fa fa-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                {else}
                    <div class="form-group mb-2 mt-2 w-100">
                        <div class="input-group">
                            <input type="text" id="password" name="password" class="form-control"
                                   value="{$service->service_password}" disabled>
                        </div>
                    </div>
                {/if}
            </div>
            <div class="col-2 d-flex align-items-center">
                <div class="form-group mb-2 mt-2">
                    <div class="input-group">
                        <button onclick="copyPassword()" id="copyPasswordButton" class="btn btn-outline-danger"
                                type="button">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{/if}
<br>

<div class="row">
    <div class="col-md-6">
        <div id="used_space" style="width: 300px; height: 300px;"></div>
    </div>
    <div class="col-md-6">
        <table class="table table-list">
            <tr style="text-align: left;">
                <td><b><i class="fa fa-battery-full"></i>&nbsp;&nbsp;{$service->lang['Disk limit']}:</b></td>
                <td>{$service->package_option_disk_limit} {$service->package_option_unit}</td>
            </tr>
            <tr style="text-align: left;">
                <td><b><i class="fa fa-database"></i>&nbsp;&nbsp;&nbsp;{$service->lang['Disk used']}:</b></td>
                <td>{$service->disk_used_unit} {$service->package_option_unit}</td>
            </tr>

            <tr style="text-align: left;">
                <td><b><i class="fa fa-recycle"></i>&nbsp;&nbsp;&nbsp;{$service->lang['Disk free']}:</b></td>
                <td>{$service->disk_free_unit} {$service->package_option_unit}</td>
            </tr>
            <tr style="text-align: left;">
                <td><b><i class="fa fa-database"></i>&nbsp;&nbsp;&nbsp;{$service->lang['Disk used percentage']}:</b>
                </td>
                <td>{$service->disk_used_percentage} %</td>
            </tr>
            <tr style="text-align: left;">
                <td><b><i class="fa fa-recycle"></i>&nbsp;&nbsp;&nbsp;{$service->lang['Disk free percentage']}:</b>
                </td>
                <td>{$service->disk_free_percentage} %</td>
            </tr>
        </table>
    </div>
</div>

<table class="table table-list">
    <tr>
        <td><b>{$service->lang['Buckets name']}</b></td>
        <td><b>{$service->lang['Objects']}</b></td>
        <td><b>{$service->lang['Size']}</b></td>
    </tr>
    {foreach from=$service->disk_service_buckets key=key item=bucket}
        <tr>
            <td><i class="fa fa-archive"></i>&nbsp;&nbsp;&nbsp;{$bucket['name']}</td>
            <td><i class="fa fa-object-ungroup"></i>&nbsp;&nbsp;&nbsp;{$bucket['objects']}</td>
            <td>
                <i class="fa fa-file"></i>&nbsp;&nbsp;&nbsp;{round($bucket['size']*$service->unit_coefficient, 4)} {$service->package_option_unit}
            </td>
        </tr>
    {/foreach}
</table>

{literal}
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    google.charts.load("current", {packages: ["corechart"]});
    google.charts.setOnLoadCallback(used_space);

    function used_space() {
        var data = google.visualization.arrayToDataTable([
            ['', ''],
            {/literal}
            ['{$service->lang['Used']}', {$service->disk_used_bytes*$service->unit_coefficient}],
            ['{$service->lang['Free']}', {$service->disk_free_bytes*$service->unit_coefficient}],
            {literal}
        ]);

        var options = {
            title: '{/literal}{$service->lang['Used space']} ({$service->package_option_unit}){literal}',
            legend: 'none',
            pieSliceText: 'label',
            chartArea: {
                height: '80%',
                width: '80%',
            },
            height: '80%',
            width: '80%',
            'backgroundColor': 'transparent',
            slices: {
                0: {color: 'red'},
                1: {color: 'green'}
            }
        };

        var chart = new google.visualization.PieChart(document.getElementById('used_space'));
        chart.draw(data, options);
    }
</script>

<script>
    var passwordField = document.getElementById('password');
    var showPasswordButton = document.getElementById('showPasswordButton');

    function startShowPassword() {
        passwordField.type = 'text';
    }

    function endShowPassword() {
        passwordField.type = 'password';
    }

    showPasswordButton.addEventListener('mousedown', startShowPassword);
    showPasswordButton.addEventListener('mouseup', endShowPassword);
    showPasswordButton.addEventListener('mouseleave', endShowPassword);

    showPasswordButton.addEventListener('touchstart', startShowPassword);
    showPasswordButton.addEventListener('touchend', endShowPassword);
    showPasswordButton.addEventListener('touchcancel', endShowPassword);


    function copyPassword() {
        const input = document.getElementById('password');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

    function copyUsername() {
        const input = document.getElementById('username');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }
</script>
{/literal}