{include file='modules/servers/puqMikrotikWireGuardVPN/templates/include/header.tpl'}

<div class="d-flex justify-content-center flex-wrap">

    {if $vpn->package_option_link_to_vpn_clients ne ""}
        <a href="{$vpn->package_option_link_to_vpn_clients}" target="_blank" class="hostbtn">
            <i class="fas fa-download"></i>{$vpn->lang['VPN client']}
        </a>
    {/if}

    {if $vpn->package_option_link_to_manual ne ""}
        <a href="{$vpn->package_option_link_to_manual}" target="_blank" class="hostbtn">
            <i class="fas fa-book"></i> {$vpn->lang['User manual']}
        </a>
    {/if}

    <a id="toptodownload" class="hostbtn">
        <i class="fa fa-download"></i> {$vpn->lang['Configuration']}
    </a>

    <a href="clientarea.php?action=productdetails&id={$vpn->service_id}&modop=custom&a=ResetVPNInterface" class="hostbtn">
        <i class="fas fa-redo"></i>{$vpn->lang['Reset VPN Interface']}
    </a>

</div>

<h5>{$vpn->lang['Network configuration']}</h5>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-toggle-on">&nbsp;&nbsp;</i>{$vpn->lang['Enable']}</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {if $vpn->peer_disabled ne "true"}
            <div style="font-size: 30px; color: green;">&#10004;</div>
        {else}
            <div style="font-size: 30px; color: red;">&#10006;</div>
        {/if}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-passport">&nbsp;&nbsp;</i>{$vpn->lang['VPN Protocol']}:</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        WireGuard
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-left mb-2 mt-2">
        <b><i class="fa fa-download">&nbsp;&nbsp;<i
                        class="fa fa-upload"></i>&nbsp;&nbsp;</i>{$vpn->lang['Bandwidth download/upload']}:</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {$vpn->package_option_bandwidth_download}/{$vpn->package_option_bandwidth_upload}M
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-map-marker-alt">&nbsp;&nbsp;</i>{$vpn->lang['Endpoint']}</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {if $vpn->peer_current_endpoint_address ne ""}
            <div>{$vpn->peer_current_endpoint_address}:{$vpn->peer_current_endpoint_port}</div>
        {else}
            N/A
        {/if}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-handshake">&nbsp;&nbsp;</i>{$vpn->lang['Latest handshake']}</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {if $vpn->peer_last_handshake ne ""}
            <div>{$vpn->peer_last_handshake}</div>
        {else}
            N/A
        {/if}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-arrow-down">&nbsp;&nbsp;</i>{$vpn->lang['Transfer RX']}</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {$vpn->peer_rx}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b><i class="fa fa-arrow-up">&nbsp;&nbsp;</i>{$vpn->lang['Transfer TX']}</b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {$vpn->peer_tx}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-12 mb-2 mt-2">
        <h3>{$vpn->lang['WireGuard configuration']}</h3>
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-12 mb-2 mt-2">
        <a class="btn btn-success" id="todownload">
            <i class="fa fa-download">&nbsp;&nbsp;</i>
            {$vpn->lang['DOWNLOAD CONFIG']}
        </a>
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-12 mb-2 mt-2">
        <img style="width:100%; max-width:500px;" src="{$config_qr}">
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-12 mb-2 mt-2">
        <pre style="text-align: left;">{$config_text}</pre>
    </div>
</div>

<script type="text/javascript">
    document.getElementById('toptodownload').onclick = function () {
        let text = `{$config_text|trim}`;
        let myData = 'data:application/txt;charset=utf-8,' + encodeURIComponent(text);
        this.href = myData;
        this.download = 'wg0.conf';
    }
</script>
<script type="text/javascript">
    document.getElementById('todownload').onclick = function () {
        let text = `{$config_text|trim}`;
        let myData = 'data:application/txt;charset=utf-8,' + encodeURIComponent(text);
        this.href = myData;
        this.download = 'wg0.conf';
    }
</script>