<h1>{$service->lang['Traffic statistics']}</h1>
<div id="last_30_days" style="width:100%; height:300px;"></div>
<hr>
<div id="avg_month" style="width:100%; height:300px;"></div>

{literal}
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    google.load("visualization", "1", {packages: ["corechart"]});
    google.setOnLoadCallback(last_30_days);

    function last_30_days() {
        var data = google.visualization.arrayToDataTable([
            ['', '{/literal}{$service->lang['Download']} GB{literal}', '{/literal}{$service->lang['Upload']} GB{literal}'],
            {/literal}
            {foreach from=$traffic_history_30 key=h_key item=h_data}
            ['{$h_key}', {round($h_data['bytes_download']/1024/1024/1024, 4)}, {round($h_data['bytes_upload']/1024/1024/1024, 4)}],
            {/foreach}
            {literal}
        ]);
        var options = {
            title: '{/literal}{$service->lang['Traffic statistics for the last 30 days.']}{literal}',
            legend: {position: 'top'},
            pieSliceText: 'label',
            chartArea: {
                height: '70%',
                width: '85%',
            },
            height: '90%',
            width: '90%',
        };
        var chart = new google.visualization.ColumnChart(document.getElementById('last_30_days'));
        chart.draw(data, options);
    }
</script>
<script>
    google.load("visualization", "1", {packages: ["corechart"]});
    google.setOnLoadCallback(avg_month);

    function avg_month() {
        var data = google.visualization.arrayToDataTable([
            ['', '{/literal}{$service->lang['Download']} GB{literal}', '{/literal}{$service->lang['Upload']} GB{literal}'],
            {/literal}
            {foreach from=$traffic_history key=h_key item=h_data}
            ['{$h_key}', {round($h_data['bytes_download']/1024/1024/1024, 4)}, {round($h_data['bytes_upload']/1024/1024/1024, 4)}],
            {/foreach}
            {literal}
        ]);
        var options = {
            title: '{/literal}{$service->lang['Total traffic for all time per month.']}{literal}',
            legend: {position: 'top'},
            pieSliceText: 'label',
            chartArea: {
                height: '70%',
                width: '85%',
            },
            height: '90%',
            width: '90%',
        };
        var chart = new google.visualization.ColumnChart(document.getElementById('avg_month'));
        chart.draw(data, options);
    }
</script>
{/literal}

