{literal}
    <style>
        .info-card {
            background: #ffffff;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
        }

        .info-card:hover {
            box-shadow: 0 4px 16px rgba(0,0,0,0.12);
        }

        .info-row {
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
            flex-wrap: wrap;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: #555;
            display: flex;
            align-items: center;
            min-width: 200px;
            margin-bottom: 10px;
        }

        .info-label i {
            margin-right: 10px;
            color: #dc3545;
            width: 20px;
            text-align: center;
        }

        .info-value {
            flex: 1;
            min-width: 250px;
        }

        .credential-value {
            font-weight: 600;
            color: #333;
            flex: 1;
            min-width: 150px;
            word-break: break-all;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: 600;
        }

        .status-online {
            background: #d4edda;
            color: #155724;
        }

        .status-offline {
            background: #f8d7da;
            color: #721c24;
        }

        .download-btn {
            background: #dc3545;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
            font-weight: 600;
        }

        .download-btn:hover {
            background: #c82333;
            color: #fff;
            text-decoration: none;
        }

        .download-btn i {
            margin-right: 8px;
        }

        .action-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }

        .action-btn {
            background: #fff;
            border: 2px solid #dc3545;
            color: #dc3545;
            border-radius: 8px;
            padding: 12px 20px;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            font-weight: 600;
            white-space: nowrap;
        }

        .action-btn:hover {
            background: #dc3545;
            color: #fff;
            text-decoration: none;
        }

        .action-btn i {
            margin-right: 8px;
            font-size: 18px;
        }

        .protocol-header {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }

        .protocol-header i {
            margin-right: 10px;
            color: #dc3545;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
            margin-top: 15px;
        }

        .stat-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            flex-wrap: wrap;
            gap: 10px;
        }

        .stat-label {
            color: #555;
            font-weight: 600;
        }

        .stat-label i {
            margin-right: 8px;
            color: #dc3545;
            width: 20px;
            text-align: center;
        }

        .stat-value {
            color: #333;
            font-weight: 500;
        }

        .config-section {
            margin-top: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }

        .qr-code-container {
            text-align: center;
            margin: 20px 0;
        }

        .qr-code-container img {
            max-width: 100%;
            width: 300px;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .config-text-container {
            background: #d6d4d4;
            color: #151515;
            padding: 20px;
            border-radius: 8px;
            overflow-x: auto;
            margin-top: 15px;
        }

        .config-text-container pre {
            margin: 0;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            line-height: 1.6;
            text-align: left;
            white-space: pre-wrap;
            word-wrap: break-word;
        }

        /* Mobile responsive styles */
        @media (max-width: 768px) {
            .info-row {
                flex-direction: column;
                align-items: flex-start;
            }

            .info-label {
                width: 100%;
                min-width: auto;
                margin-bottom: 10px;
            }

            .info-value {
                width: 100%;
                min-width: auto;
            }

            .credential-value {
                min-width: auto;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .stat-item {
                flex-direction: column;
                align-items: flex-start;
            }

            .action-buttons {
                flex-direction: column;
            }

            .action-btn {
                width: 100%;
                justify-content: center;
            }

            .qr-code-container img {
                width: 100%;
                max-width: 300px;
            }
        }

        @media (max-width: 480px) {
            .info-card {
                padding: 15px;
            }

            .action-btn {
                padding: 10px 15px;
                font-size: 14px;
            }

            .config-text-container {
                padding: 15px;
            }

            .config-text-container pre {
                font-size: 12px;
            }
        }
    </style>
{/literal}

<!-- Action Buttons -->
<div class="action-buttons">
    {if $vpn->package_option_link_to_vpn_clients ne ""}
        <a href="{$vpn->package_option_link_to_vpn_clients}" target="_blank" class="action-btn">
            <i class="fas fa-download"></i> {$vpn->lang['VPN client']}
        </a>
    {/if}

    {if $vpn->package_option_link_to_instruction ne ""}
        <a href="{$vpn->package_option_link_to_instruction}" target="_blank" class="action-btn">
            <i class="fas fa-book"></i> {$vpn->lang['User manual']}
        </a>
    {/if}

    <a href="clientarea.php?action=productdetails&id={$vpn->service_id}&modop=custom&a=ResetVPNInterface" class="action-btn">
        <i class="fas fa-redo"></i> {$vpn->lang['Reset VPN Interface']}
    </a>
</div>

<!-- Network Configuration Card -->
<div class="info-card">
    <div class="protocol-header">
        <i class="fa fa-cog"></i>
        {$vpn->lang['Network configuration']}
    </div>

    <div class="info-row">
        <div class="info-label">
            <i class="fa fa-toggle-on"></i>
            {$vpn->lang['Enable']}:
        </div>
        <div class="info-value">
            {if $vpn->peer_disabled ne "true"}
                <span class="status-badge status-online">
                    <i class="fa fa-check-circle"></i> &nbsp; {$vpn->lang['Enabled']}
                </span>
            {else}
                <span class="status-badge status-offline">
                    <i class="fa fa-times-circle"></i> &nbsp; {$vpn->lang['Disabled']}
                </span>
            {/if}
        </div>
    </div>

    <div class="info-row">
        <div class="info-label">
            <i class="fa fa-passport"></i>
            {$vpn->lang['VPN Protocol']}:
        </div>
        <div class="info-value">
            <div class="credential-value">WireGuard</div>
        </div>
    </div>

    <div class="info-row">
        <div class="info-label">
            <i class="fa fa-download"></i>
            <i class="fa fa-upload"></i>
            {$vpn->lang['Bandwidth download/upload']}:
        </div>
        <div class="info-value">
            <div class="credential-value">{$vpn->package_option_bandwidth_download}/{$vpn->package_option_bandwidth_upload} Mb/s</div>
        </div>
    </div>
</div>

<!-- Connection Status Card -->
<div class="info-card">
    <div class="protocol-header">
        <i class="fa fa-signal"></i>
        {$vpn->lang['Connection Status']}
    </div>

    <div class="stats-grid">
        <div class="stat-item">
            <span class="stat-label">
                <i class="fa fa-map-marker-alt"></i>
                {$vpn->lang['Endpoint']}:
            </span>
            <span class="stat-value">
                {if $vpn->peer_current_endpoint_address ne ""}
                    {$vpn->peer_current_endpoint_address}:{$vpn->peer_current_endpoint_port}
                {else}
                    <span style="color: #dc3545;">N/A</span>
                {/if}
            </span>
        </div>

        <div class="stat-item">
            <span class="stat-label">
                <i class="fa fa-handshake"></i>
                {$vpn->lang['Latest handshake']}:
            </span>
            <span class="stat-value">
                {if $vpn->peer_last_handshake ne ""}
                    {$vpn->peer_last_handshake}
                {else}
                    <span style="color: #dc3545;">N/A</span>
                {/if}
            </span>
        </div>

        <div class="stat-item">
            <span class="stat-label">
                <i class="fa fa-arrow-down"></i>
                {$vpn->lang['Transfer RX']}:
            </span>
            <span class="stat-value">{$vpn->peer_rx}</span>
        </div>

        <div class="stat-item">
            <span class="stat-label">
                <i class="fa fa-arrow-up"></i>
                {$vpn->lang['Transfer TX']}:
            </span>
            <span class="stat-value">{$vpn->peer_tx}</span>
        </div>
    </div>
</div>

<!-- WireGuard Configuration Card -->
<div class="info-card">
    <div class="protocol-header">
        <i class="fa fa-shield-alt"></i>
        {$vpn->lang['WireGuard configuration']}
    </div>

    <div class="info-row">
        <div class="info-label">
            <i class="fa fa-download"></i>
            {$vpn->lang['Configuration']}:
        </div>
        <div class="info-value">
            <a class="download-btn" id="todownload">
                <i class="fa fa-download"></i>
                {$vpn->lang['DOWNLOAD CONFIG']}
            </a>
        </div>
    </div>

    <div class="config-section">
        <div class="qr-code-container">
            <img src="{$config_qr}" alt="WireGuard QR Code">
        </div>

        <div class="config-text-container">
            <pre>{$config_text}</pre>
        </div>
    </div>
</div>

<script type="text/javascript">
    {literal}
    document.getElementById('todownload').onclick = function () {
        let text = `{/literal}{$config_text|trim}{literal}`;
        let myData = 'data:application/txt;charset=utf-8,' + encodeURIComponent(text);
        this.href = myData;
        this.download = 'wg0.conf';
    }
    {/literal}
</script>