<div class="row">

    {* Mikrotik WireGuard & Bandwidth *}
    <div class="col-xs-12 col-sm-6">
        <div class="panel panel-info">
            <div class="panel-heading">Mikrotik & Bandwidth</div>
            <div class="panel-body">

                <div class="form-group">
                    <label>WireGuard Interface</label>
                    <input type="text"
                           name="packageconfigoption[24][mikrotik_wireguard]"
                           class="form-control"
                           value="{$package_options.mikrotik_wireguard|default:'wireguard'}">
                    <span class="help-block">Name of the WireGuard interface on Mikrotik router</span>
                </div>

                <div class="form-group">
                    <label>Comment prefix</label>
                    <input type="text"
                           name="packageconfigoption[24][comment_prefix]"
                           class="form-control"
                           value="{$package_options.comment_prefix|default:'whmcs'}">
                </div>
                <hr>

                <div class="form-group">
                    <label>Upload (Mbs/s)</label>
                    <input type="number"
                           name="packageconfigoption[24][bandwidth_upload]"
                           class="form-control"
                           value="{$package_options.bandwidth_upload|default:1}">
                </div>

                <div class="form-group">
                    <label>Download (Mbs/s)</label>
                    <input type="number"
                           name="packageconfigoption[24][bandwidth_download]"
                           class="form-control"
                           value="{$package_options.bandwidth_download|default:1}">
                </div>

            </div>
        </div>

        <div class="panel panel-info">
            <div class="panel-heading"><span class="glyphicon glyphicon-time"></span> History</div>
            <div class="panel-body">
                <div class="form-group">
                    <div class="checkbox">
                        <label>
                            <input type="hidden" name="packageconfigoption[24][disable_statistics_collection]" value="">
                            <input type="checkbox"
                                   name="packageconfigoption[24][disable_statistics_collection]"
                                   value="1"
                                   {if $package_options.disable_statistics_collection}checked{/if}>
                            Disable statistics collection
                        </label>
                    </div>
                    <span class="help-block">When enabled, traffic statistics will not be collected and the statistics page will be hidden from the client area</span>
                </div>

                <div class="form-group">
                    <label>Save history (days)</label>
                    <input type="number"
                           name="packageconfigoption[24][save_usage_history]"
                           class="form-control"
                           min="32"
                           value="{$package_options.save_usage_history|default:32}">
                    <span class="help-block">Number of days to keep usage statistics in WHMCS (minimum 32 days)</span>
                </div>
            </div>
        </div>
    </div>

    {* WireGuard Configuration *}
    <div class="col-xs-12 col-sm-6">
        <div class="panel panel-info">
            <div class="panel-heading"><span class="glyphicon glyphicon-lock"></span> WireGuard Configuration</div>
            <div class="panel-body">

                <div class="form-group">
                    <label>Allowed IPs</label>
                    <input type="text"
                           name="packageconfigoption[24][allowed_ips]"
                           class="form-control"
                           value="{$package_options.allowed_ips|default:'0.0.0.0/0, ::/0'}">
                    <span class="help-block">
                        IP ranges allowed to route through the VPN tunnel.<br>
                        <strong>Default:</strong> <code>0.0.0.0/0, ::/0</code> (all IPv4 and IPv6 traffic)<br>
                        <strong>Example for split-tunnel:</strong> <code>10.0.0.0/8, 192.168.0.0/16</code>
                    </span>
                </div>

                <div class="form-group">
                    <label>DNS Servers</label>
                    <input type="text"
                           name="packageconfigoption[24][dns_servers]"
                           class="form-control"
                           value="{$package_options.dns_servers|default:''}">
                    <span class="help-block">
                        DNS servers to use when connected to VPN (comma-separated).<br>
                        <strong>Example:</strong> <code>8.8.8.8, 8.8.4.4</code> or <code>1.1.1.1, 1.0.0.1</code><br>
                        Leave empty to use system defaults.
                    </span>
                </div>

                <div class="form-group">
                    <label>Persistent Keepalive</label>
                    <select name="packageconfigoption[24][persistent_keepalive]" class="form-control">
                        <option value="15" {if $package_options.persistent_keepalive == '15'}selected{/if}>
                            15 seconds
                        </option>
                        <option value="25" {if $package_options.persistent_keepalive == '25'}selected{/if}>
                            25 seconds (recommended)
                        </option>
                        <option value="30" {if $package_options.persistent_keepalive == '30'}selected{/if}>
                            30 seconds
                        </option>
                        <option value="60" {if $package_options.persistent_keepalive == '60'}selected{/if}>
                            60 seconds
                        </option>
                        <option value="120" {if $package_options.persistent_keepalive == '120'}selected{/if}>
                            120 seconds
                        </option>
                    </select>
                    <span class="help-block">
                        Interval for sending keepalive packets to maintain NAT mappings and firewall states.<br>
                        <strong>Recommended:</strong> 25 seconds for clients behind NAT/firewall<br>
                    </span>
                </div>

            </div>
        </div>
    </div>

    {* Client Area Settings *}
    <div class="col-xs-12 col-sm-6">
        <div class="panel panel-info">
            <div class="panel-heading"><span class="glyphicon glyphicon-dashboard"></span> Client Area</div>
            <div class="panel-body">
                <div class="form-group">
                    <label>Link to instruction</label>
                    <input type="text"
                           name="packageconfigoption[24][link_to_instruction]"
                           class="form-control"
                           value="{$package_options.link_to_instruction|default:''}">
                    <span class="help-block">URL to setup instructions (displayed in client area)</span>
                </div>

                <div class="form-group">
                    <label>Link to VPN clients</label>
                    <input type="text"
                           name="packageconfigoption[24][link_to_vpn_clients]"
                           class="form-control"
                           value="{$package_options.link_to_vpn_clients|default:''}">
                    <span class="help-block">
                        URL to WireGuard client downloads page.<br>
                        <strong>Official:</strong> <code>https://www.wireguard.com/install/</code>
                    </span>
                </div>
            </div>
        </div>
    </div>

</div>