{include file='modules/servers/puqMikrotikVPN/templates/include/header.tpl'}

<div class="d-flex justify-content-center flex-wrap">

    {if $service->package_option_link_to_instruction ne ''}
        <a href="{$service->package_option_link_to_instruction}" target="_blank" class="hostbtn">
            <i class="fas fa-book"></i> {$service->lang['Connection setup instructions']}
        </a>
    {/if}

</div>

{if !$vpn_user_enables}
    <div class="alert alert-danger text-center">{$service->lang['The account is blocked, check the traffic balance.']}</div>
{/if}

<h4>{$service->lang['info_1']}</h4>

<div class="row border-bottom">
    <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
        <b>
            <i class="fa fa-server">&nbsp;&nbsp;</i>
            {$service->lang['server_address']}:
        </b>
    </div>
    <div class="col-md-4 mb-2 mt-2">
        {$service->server_hostname}
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fa fa-user"></i>&nbsp;&nbsp;{$service->lang['username']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center">
                <strong>{$service->service_username}</strong>
            </div>
            <div class="col-2 d-flex align-items-center">
                <div class="form-group mb-2 mt-2">
                    <div class="input-group">
                        <input type="hidden" name="username" id="username" value="{$service->service_username}">
                        <button onclick="copyUsername()" id="copyUsernameButton" class="btn btn-outline-danger"
                                type="button">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fa fa-lock"></i>&nbsp;&nbsp;{$service->lang['password']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center">
                <div class="form-group mb-2 mt-2 w-100">
                    <div class="input-group">
                        <input type="password" id="password" name="password" class="form-control"
                               value="{$service->service_password}" disabled>
                        <div class="input-group-append">
                            <button id="showPasswordButton" class="btn btn-outline-secondary" type="button">
                                <i class="fa fa-eye"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-2 d-flex align-items-center">
                <div class="form-group mb-2 mt-2">
                    <div class="input-group">
                        <button onclick="copyPassword()" id="copyPasswordButton" class="btn btn-outline-danger"
                                type="button">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<h4>{$service->lang['VPN protocols']}</h4>

{if $service->package_option_protocol_pptp eq "yes"}
    <div class="border-bottom">
        <div class="row">
            <div class="col-8 d-flex align-items-center mb-2 mt-2">
                <b><i class="fa fa-passport">&nbsp;&nbsp;</i>PPtP:</b>
            </div>
            <div class="col-4 mb-2 mt-2">
                <b style="font-size:20px; color:green;">✔</b>
            </div>
        </div>
        {if $service->package_option_pptp_html ne ""}
            <div id="pptp-container"></div>
        {/if}
    </div>
{/if}

{if $service->package_option_protocol_l2tp eq "yes"}
    <div class="border-bottom">
        <div class="row">
            <div class="col-8 d-flex align-items-center mb-2 mt-2">
                <b><i class="fa fa-passport">&nbsp;&nbsp;</i>L2TP PSK:</b>
            </div>
            <div class="col-4 mb-2 mt-2">
                <b style="font-size:20px; color:green;">✔</b>
            </div>
        </div>
        <div class="row ">
            <div class="col-md-4 d-flex align-items-center">
                <i class="fa fa-key">&nbsp;&nbsp;</i>
                {$service->lang['L2TP IPSec PSK key']}:
            </div>
            <div class="col-md-8">
                <div class="row">
                    <div class="col-10 d-flex align-items-center">
                        <div class="form-group mb-2 mt-2 w-100">
                            <div class="input-group">
                                <input type="password" id="l2tp_psk_key" name="l2tp_psk_key" class="form-control"
                                       value="{$service->package_option_l2tp_psk_key}" disabled>
                                <div class="input-group-append">
                                    <button id="showL2tpPskKeyButton" class="btn btn-outline-secondary" type="button">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-2 d-flex align-items-center">
                        <div class="form-group mb-2 mt-2">
                            <div class="input-group">
                                <button onclick="copyL2tpPskKey()" id="copyL2tpPskKeyButton"
                                        class="btn btn-outline-danger"
                                        type="button">
                                    <i class="fa fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {if $service->package_option_l2tp_html ne ""}
            <div id="l2tp-container"></div>
        {/if}
    </div>
{/if}

{if $service->package_option_protocol_ovpn eq "yes"}
    <div class="border-bottom">
        <div class="row">
            <div class="col-8 d-flex align-items-center mb-2 mt-2">
                <b><i class="fa fa-passport">&nbsp;&nbsp;</i>Open VPN:</b>
            </div>
            <div class="col-4 mb-2 mt-2">
                <b style="font-size:20px; color:green;">✔</b>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8 d-flex align-items-center mb-2 mt-2">
                <b>
                    <i class="fa fa-key">&nbsp;&nbsp;</i>
                    {$service->lang['Open VPN profile']}:
                </b>
            </div>
            <div class="col-md-4 mb-2 mt-2">
                <a href="{$service->package_option_ovpn_profile_url}" class="btn btn-primary">
                    <i class="fa fa-download"></i> {$service->lang['Download']}
                </a>
            </div>
        </div>

        {if $service->package_option_ovpn_html ne ""}
            <div id="ovpn-container"></div>
        {/if}
    </div>
{/if}

{if $service->package_option_protocol_sstp eq "yes"}
    <div class="border-bottom">
        <div class="row">
            <div class="col-8 d-flex align-items-center mb-2 mt-2">
                <b><i class="fa fa-passport">&nbsp;&nbsp;</i>SStP:</b>
            </div>
            <div class="col-4 mb-2 mt-2">
                <b style="font-size:20px; color:green;">✔</b>
            </div>
        </div>
        {if $service->package_option_sstp_html ne ""}
            <div id="sstp-container"></div>
        {/if}
    </div>
{/if}




{if $vpn_user_online['name']}
    <div class="alert alert-success text-center"><i class="fa fa-signal"></i>&nbsp;&nbsp;ONLINE</div>
{else}
    <div class="alert alert-danger text-center"><i class="fa fa-signal-slash"></i>&nbsp;&nbsp;OFFLINE</div>
{/if}

<div class="row">
    <div class="col-md-6">
        <table style="width:100%; text-align: left;" class="table table-striped">
            <tr>
                <td><i class="fa fa-passport"></i>&nbsp;&nbsp;<b>{$service->lang['Service']}:</b></td>
                <td style="text-align: center;">
                    {if $vpn_user_online['service']}{$vpn_user_online['service']}{else}
                        <b style="font-size:20px; color:red;">✖</b>
                    {/if}
                </td>
            </tr>
            <tr>
                <td><i class="fa fa-user"></i>&nbsp;&nbsp;<b>{$service->lang['Name']}:</b></td>
                <td style="text-align: center;">
                    {if $vpn_user_online['name']}{$vpn_user_online['name']}{else}
                        <b style="font-size:20px; color:red;">✖</b>
                    {/if}
                </td>
            </tr>
            <tr>
                <td><i class="fa fa-address-book"></i>&nbsp;&nbsp;<b>{$service->lang['Address']}:</b></td>
                <td style="text-align: center;">
                    {if $vpn_user_online['address']}{$vpn_user_online['address']}{else}
                        <b style="font-size:20px; color:red;">✖</b>
                    {/if}
                </td>
            </tr>
            <tr>
                <td><i class="fa fa-clock"></i>&nbsp;&nbsp;<b>{$service->lang['Uptime']}:</b></td>
                <td style="text-align: center;">
                    {if $vpn_user_online['uptime']}{$vpn_user_online['uptime']}{else}
                        <b style="font-size:20px; color:red;">✖</b>
                    {/if}
                </td>
            </tr>
        </table>
    </div>
    <div class="col-md-6">
        <table style="width:100%; text-align: left;" class="table table-striped">
            <tr>
                <td><i class="fa fa-globe"></i><b>&nbsp;&nbsp;{$service->lang['Traffic balance']}</b></td>
                {if $service->service_traffic_billingcycle_gb ne 0}
                    {if $service->service_traffic_balance_gb lt 0 }
                        <td nowrap style="text-align: center;"><b
                                    style="color: red;"><b> {$service->service_traffic_balance_gb} GB</b></td>
                    {else}
                        <td nowrap style="text-align: center;"><b
                                    style="color: green;"><b> {$service->service_traffic_balance_gb} GB</b></td>
                    {/if}
                {else}
                    <td nowrap style="text-align: center;"><b><b>Unlimited</b></td>
                {/if}
            </tr>
            <tr>
                <td><i class="fa fa-download"></i>&nbsp;&nbsp;<b>{$service->lang['Bandwidth download']}</b></td>
                <td nowrap style="text-align: center;"><b>{$service->package_option_bandwidth_download} Mb/s</b></td>
            </tr>
            <tr>
                <td><i class="fa fa-upload"></i>&nbsp;&nbsp;<b>{$service->lang['Bandwidth upload']}</b></td>
                <td nowrap style="text-align: center;"><b>{$service->package_option_bandwidth_upload} Mb/s</b></td>
            </tr>
            <tr>
                <td><i class="fa fa-recycle"></i>&nbsp;&nbsp;<b>{$service->lang['Traffic billingcycle']}</b></td>
                <td nowrap style="text-align: center;"><b>{$service->service_traffic_billingcycle_gb} GB</b></td>
            </tr>
        </table>


        {if $availability_addons}
            <form method="post" action="{$service->SystemURL}/cart.php?a=add">
                <table style="width:100%">

                    <tr>
                        <td nowrap>
                            <input type="hidden" name="productid" value="{$service->service_id}"/>
                            <header class="col-12">
                                <span>{$service->lang['BUY ADDITIONAL TRAFFIC']}</span>
                            </header>
                        </td>
                    </tr>
                    <tr>
                        <td nowrap>
                            <p></p>
                            <select name="aid" id="inputAid" class="field form-control">
                                {foreach from=$availability_addons key=a_key item=addons}
                                    <option value="{$addons['addon_id']}"> {$addons['addon_name']}
                                        ( {$service->currency_prefix} {$addons['addon_price']} {$service->currency_suffix}
                                        /{$service->lang[$addons['addon_billingcycle']]} )
                                    </option>
                                {/foreach}
                            </select>
                        </td>
                    </tr>

                    <tr>
                        <td nowrap>
                            <br>
                            <footer class="col-12 text-right">
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-shopping-cart"></i> {$service->lang['Order Now']}</button>
                            </footer>
                        </td>
                    </tr>
                </table>
            </form>
        {/if}
    </div>
</div>


<script>
    const pptpHtml = `{$service->package_option_pptp_html}`;
    const l2tpHtml = `{$service->package_option_l2tp_html}`;
    const ovpnHtml = `{$service->package_option_ovpn_html}`;
    const sstpHtml = `{$service->package_option_sstp_html}`;
    document.addEventListener("DOMContentLoaded", function () {
        const pptp_container = document.getElementById("pptp-container");
        if (pptp_container) {
            pptp_container.innerHTML = decodeHtmlEntities(pptpHtml);
        }

        const l2tp_container = document.getElementById("l2tp-container");
        if (l2tp_container) {
            l2tp_container.innerHTML = decodeHtmlEntities(l2tpHtml);
        }

        const ovpn_container = document.getElementById("ovpn-container");
        if (ovpn_container) {
            ovpn_container.innerHTML = decodeHtmlEntities(ovpnHtml);
        }

        const sstp_container = document.getElementById("sstp-container");
        if (sstp_container) {
            sstp_container.innerHTML = decodeHtmlEntities(sstpHtml);
        }
    });

    {literal}
    var passwordField = document.getElementById('password');
    var showPasswordButton = document.getElementById('showPasswordButton');

    function startShowPassword() {
        passwordField.type = 'text';
    }

    function endShowPassword() {
        passwordField.type = 'password';
    }

    showPasswordButton.addEventListener('mousedown', startShowPassword);
    showPasswordButton.addEventListener('mouseup', endShowPassword);
    showPasswordButton.addEventListener('mouseleave', endShowPassword);

    showPasswordButton.addEventListener('touchstart', startShowPassword);
    showPasswordButton.addEventListener('touchend', endShowPassword);
    showPasswordButton.addEventListener('touchcancel', endShowPassword);


    function copyPassword() {
        const input = document.getElementById('password');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

    function copyUsername() {
        const input = document.getElementById('username');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

    var L2tpPskKeyField = document.getElementById('l2tp_psk_key');
    var showL2tpPskKeyButton = document.getElementById('showL2tpPskKeyButton');

    function startShowL2tpPskKey() {
        L2tpPskKeyField.type = 'text';
    }

    function endShowL2tpPskKey() {
        L2tpPskKeyField.type = 'password';
    }

    showL2tpPskKeyButton.addEventListener('mousedown', startShowL2tpPskKey);
    showL2tpPskKeyButton.addEventListener('mouseup', endShowL2tpPskKey);
    showL2tpPskKeyButton.addEventListener('mouseleave', endShowL2tpPskKey);

    showL2tpPskKeyButton.addEventListener('touchstart', startShowL2tpPskKey);
    showL2tpPskKeyButton.addEventListener('touchend', endShowL2tpPskKey);
    showL2tpPskKeyButton.addEventListener('touchcancel', endShowL2tpPskKey);

    function copyL2tpPskKey() {
        const input = document.getElementById('l2tp_psk_key');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

    function decodeHtmlEntities(str) {
        const parser = new DOMParser();
        const doc = parser.parseFromString(str, 'text/html');
        return doc.documentElement.textContent;
    }

    {/literal}

</script>
