{include file='modules/servers/puqJellyfin/templates/include/header.tpl'}

<div class="d-flex justify-content-center flex-wrap">

    {if $service->package_option_link_to_manual ne ""}
        <a href="{$service->package_option_link_to_manual}" target="_blank" class="hostbtn">
            <i class="fa fa-info-circle"></i> {$service->lang['User manual']}
        </a>
    {/if}

    <a href="{$service->server_httpprefix}://{$service->server_hostname}:{$service->server_port}" target="_blank"
       class="hostbtn">
        <i class="far fa-share-square"></i>{$service->lang['Web interface']}
    </a>

</div>
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fa fa-user"></i>&nbsp;&nbsp;{$service->lang['Username']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <strong>{$service->service_username}</strong>
            </div>
            <div class="col-2 d-flex align-items-center">
                <div class="form-group mb-2 mt-2">
                    <div class="input-group">
                        <input type="hidden" name="username" id="username" value="{$service->service_username}">
                        <button onclick="copyUsername()" id="copyUsernameButton" class="btn btn-outline-danger"
                                type="button">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{if $service->package_option_show_password != 'no'}
    <div class="row border-bottom">
        <div class="col-md-4 d-flex align-items-center">
            <b><i class="fa fa-lock"></i>&nbsp;&nbsp;{$service->lang['Password']}:</b>
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-10 d-flex align-items-center justify-content-center">
                    {if $service->package_option_show_password == 'show_button'}
                        <div class="form-group mb-2 mt-2 w-100">
                            <div class="input-group">
                                <input type="password" id="password" name="password" class="form-control"
                                       value="{$service->service_password}" disabled>
                                <div class="input-group-append">
                                    <button id="showPasswordButton" class="btn btn-outline-secondary" type="button">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    {else}
                        <div class="form-group mb-2 mt-2 w-100">
                            <div class="input-group">
                                <input type="text" id="password" name="password" class="form-control"
                                       value="{$service->service_password}" disabled>
                            </div>
                        </div>
                    {/if}
                </div>
                <div class="col-2 d-flex align-items-center">
                    <div class="form-group mb-2 mt-2">
                        <div class="input-group">
                            <button onclick="copyPassword()" id="copyPasswordButton" class="btn btn-outline-danger"
                                    type="button">
                                <i class="fa fa-copy"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{/if}
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fas fa-user-slash"></i>&nbsp;&nbsp;{$service->lang['Status']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <div class="form-group mb-2 mt-2">
                    <strong>
                        {if $service->remote_user['Policy']['IsDisabled'] != '1'}
                        <span style="color:green;">{$service->lang['Enable']}</span>
                        {else}
                        <span style="color:red;">{$service->lang['Disable']}&nbsp;&nbsp;
                    {/if}
                    </strong>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fas fa-photo-video"></i>&nbsp;&nbsp;{$service->lang['Libraries']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <div class="form-group mb-2 mt-2">
                    <strong>{$service->HtmlAdminInformationLibraries()}</strong>
                </div>
            </div>
        </div>
    </div>
</div>
{if $service->remote_user['Policy']['LoginAttemptsBeforeLockout'] != -1}
    <div class="row border-bottom">
        <div class="col-md-4 d-flex align-items-center">
            <b><i class="fas fa-times"></i>&nbsp;&nbsp;{$service->lang['Failed Login Attempt']}:</b>
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-10 d-flex align-items-center justify-content-center">
                    <div class="form-group mb-2 mt-2">
                        <strong>{$service->remote_user['Policy']['InvalidLoginAttemptCount']}
                            /{$service->remote_user['Policy']['LoginAttemptsBeforeLockout']}</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
{/if}
{if $service->remote_user['Policy']['MaxActiveSessions'] != 0 or !empty($service->remote_user['Policy']['MaxActiveSessions'])}
    <div class="row border-bottom">
        <div class="col-md-4 d-flex align-items-center">
            <b><i class="fa fa-users"></i>&nbsp;&nbsp;{$service->lang['Active Sessions']}:</b>
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-10 d-flex align-items-center justify-content-center">
                    <div class="form-group mb-2 mt-2">
                        <strong>{$all_sessions}/{$service->remote_user['Policy']['MaxActiveSessions']}</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
{/if}
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fas fa-user-slash"></i>&nbsp;&nbsp;{$service->lang['Active Devices']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <div class="form-group mb-2 mt-2">
                    <strong>
                        {$count_of_devices}
                    </strong>
                </div>
            </div>
        </div>
    </div>
</div>
<table style="width:100%" class="table">
    <tr style="text-align: left;">
        <td colspan="2">{$active_devices}</td>
    </tr>
</table>
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fas fa-user-slash"></i>&nbsp;&nbsp;{$service->lang['Streaming bitrate limit']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <div class="form-group mb-2 mt-2">
                    <strong>{$service->remote_user['Policy']['RemoteClientBitrateLimit'] / 1000000} Mbps</strong></div>
            </div>
        </div>
    </div>
</div>
<div class="row border-bottom">
    <div class="col-md-4 d-flex align-items-center">
        <b><i class="fas fa-sync"></i>&nbsp;&nbsp;{$service->lang['Sync Play Access']}:</b>
    </div>
    <div class="col-md-8">
        <div class="row">
            <div class="col-10 d-flex align-items-center justify-content-center">
                <div class="form-group mb-2 mt-2">
                    <strong>
                        {if $service->remote_user['Policy']['SyncPlayAccess'] == 'CreateAndJoinGroups'}
                            {$service->lang['Allow to create and join groups']}
                        {elseif $this->remote_user['Policy']['SyncPlayAccess'] == 'JoinGroups'}
                            {$service->lang['Allow to join groups']}
                        {elseif $this->remote_user['Policy']['SyncPlayAccess'] == 'None'}
                            {$service->lang['Disabled']}
                        {/if}
                    </strong></div>
            </div>
        </div>
    </div>
</div>
{literal}
    <script>
        var passwordField = document.getElementById('password');
        var showPasswordButton = document.getElementById('showPasswordButton');

        function startShowPassword() {
            passwordField.type = 'text';
        }

        function endShowPassword() {
            passwordField.type = 'password';
        }

        showPasswordButton.addEventListener('mousedown', startShowPassword);
        showPasswordButton.addEventListener('mouseup', endShowPassword);
        showPasswordButton.addEventListener('mouseleave', endShowPassword);

        showPasswordButton.addEventListener('touchstart', startShowPassword);
        showPasswordButton.addEventListener('touchend', endShowPassword);
        showPasswordButton.addEventListener('touchcancel', endShowPassword);

        function copyPassword() {
            const input = document.getElementById('password');
            navigator.clipboard.writeText(input.value).then(() => {
                alert('Copied to clipboard: ' + input.value);
            }).catch(err => {
                console.error('Copy error: ', err);
            });
        }

        function copyUsername() {
            const input = document.getElementById('username');
            navigator.clipboard.writeText(input.value).then(() => {
                alert('Copied to clipboard: ' + input.value);
            }).catch(err => {
                console.error('Copy error: ', err);
            });
        }

    </script>
{/literal}