<button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#changeOwnerPasswordModal">
    <i class="fa fa-key"></i>
    {$service->lang['Change Owner Password']}
</button>

<div class="modal" id="changeOwnerPasswordModal" tabindex="-1" role="dialog"
     aria-labelledby="changeOwnerPasswordModalLabel"
     aria-hidden="true">

     <div class="modal-dialog" role="document">
     <div class="modal-content">
         <div class="modal-header">
             <h5 class="modal-title"
                 id="changeOwnerPasswordModalLabel">{$service->lang['Change Owner Password']}</h5>
             <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                 <span aria-hidden="true">&times;</span>
             </button>
         </div>
         <form id="changeOwnerPassword" method="post" action="{$url}">
             <div class="modal-body">
                 <div class="input-group margin-bottom-5">
                     <input class="form-control" type="text" name="password" id="password"
                            placeholder="{$service->lang['New Password']}">
                     <div class="input-group-append">
                         <button type="button" id="input-generate" class="btn btn-primary">&nbsp;&nbsp;<i
                                     class="fa fa-dice"></i>&nbsp;&nbsp;{$service->lang['Generate']}</button>
                     </div>
                 </div>
             </div>
             <div class="modal-footer">
                 <button type="submit" name="submit" value="changeOwnerPassword" class="btn btn-primary"
                         form="changeOwnerPassword" id="changeOwnerPasswordSubmitButton">
                     <i class="fa fa-save"></i> {$service->lang['Save']}
                 </button>
             </div>
         </form>
     </div>
 </div>
</div>

<script>
    document.getElementById('changeOwnerPasswordSubmitButton').addEventListener('click', function (event) {
        showLoader();
    });

    $("#input-generate").click(function () {
        $("#password").val(generatePassword());
        return false;
    });

    function generatePassword() {
        var length = 12,
            charset = "123456789ABCDEFGHJKMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz";
        if (window.crypto && window.crypto.getRandomValues) {
            return Array(length)
                .fill(charset)
                .map(x => x[Math.floor(crypto.getRandomValues(new Uint32Array(1))[0] / (0xffffffff + 1) * (x.length + 1))])
                .join('');
        } else {
            res = '';
            for (var i = 0, n = charset.length; i < length; ++i) {
                res += charset.charAt(Math.floor(Math.random() * n));
            }
            return res;
        }
    }
</script>