<br>
<svg width="143" height="40" viewBox="0 0 489 232" fill="none" xmlns="http://www.w3.org/2000/svg" data-v-3baeee6e=""
     class="">
    <path fill="#0082C9" d="M244.8,7c-49.5,0-91.5,33.4-104.5,78.9c-11.4-24-35.7-40.8-64-40.8c-38.9,0-70.7,31.8-70.7,70.7s31.8,70.7,70.7,70.7
	c28.3,0,52.6-16.9,64-40.8c13,45.6,55,78.9,104.5,78.9c49.1,0,90.7-33,104.1-77.8c11.4,23.6,35.7,40.1,63.6,40.1
	c38.9,0,70.7-31.8,70.7-70.7s-31.8-70.7-70.7-70.7c-27.9,0-51.8,16.5-63.6,40.1C335.5,40,293.9,7,244.8,7z M244.8,48.2
	c37.3,0,67.2,29.9,67.2,67.2s-29.9,67.2-67.2,67.2s-67.2-29.9-67.2-67.2S207.5,48.2,244.8,48.2z M76.3,86.3
	c16.5,0,29.1,13,29.1,29.1c0,16.5-13,29.1-29.1,29.1c-16.5,0-29.1-13-29.1-29.1C47.2,99.3,60.2,86.3,76.3,86.3z M412.5,86.3
	c16.5,0,29.1,13,29.1,29.1c0,16.5-13,29.1-29.1,29.1c-16.5,0-29.1-13-29.1-29.1C383,99.3,396,86.3,412.5,86.3z"/>
</svg>
<br>
<h4><a href="https://{$service->service_domain}/" target="_blank">
        https://{$service->service_domain}/
    </a>
</h4>

<div class="form-group text-center">
    {include file='modules/servers/puqDockerNextCloud/templates/change_owner_password.tpl'}
</div>

<div class="row border-bottom">
<div class="col-md-4 d-flex align-items-center mb-2 mt-2">
  <b><i class="fa fa-user">&nbsp;&nbsp;</i>{$service->lang['Username']}:</b>
</div>
<div class="col-md-8 mb-2 mt-2">
  <div class="input-group">
      <input type="text" id="serverLogin" class="form-control"
          value="{$service->service_username}" disabled>
      <div class="input-group-btn input-group-append">
          <button type="button" onclick="copyServerLogin()" class="btn btn-outline-danger">
              <span class="border-span">
                  <i class="fa fa-copy"></i>
              </span>
          </button>
      </div>
  </div>


</div>
</div>
<div class="row border-bottom">
<div class="col-md-4 d-flex align-items-center mb-2 mt-2">
  <b><i class="fa fa-lock">&nbsp;&nbsp;</i>{$service->lang['Password']}:</b>
</div>
<div class="col-md-8 mb-2 mt-2">
  <div class="d-flex" style="width: 100%;">
    <div class="input-group" style="flex: 1;">
      <input type="password" id="password_input" name="password_input" class="form-control" value="{$service->service_password}" disabled>
      <div class="input-group-append">
        <button id="showPasswordButton" class="btn btn-outline-secondary" type="button">
          <i class="fa fa-eye"></i>
        </button>
        <button onclick="copyPassword()" id="copyPasswordButton" class="btn btn-outline-danger" type="button">
          <i class="fa fa-copy"></i>
        </button>
      </div>
    </div>
  </div>
</div>
</div>

<div class="panel panel-default" style="margin-top: 8px;">
    <div class="panel-body" style="padding-top: 8px; padding-bottom: 5px;">

        <div id="app_loader" class="bloader" style="display: none; height: 100px;">
            <i class="fas fa-sync fa-spin fa-5x"></i>
        </div>

        <div id="appInfo">
            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-cogs"></i>&nbsp;&nbsp;{$service->lang['Version']}:</b>
                </div>
                <div class="col-md-8">
                    <b id="app_version" class="text-success"></b>
                </div>
            </div>

            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-user"></i>&nbsp;&nbsp;{$service->lang['Owner']}:</b>
                </div>
                <div class="col-md-8">
                    <span id="app_owner"></span>
                </div>
            </div>

            <div class="row border-bottom users-row">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-users"></i>&nbsp;&nbsp;{$service->lang['Users']}:</b>
                </div>
                <div class="col-md-8">
                    <span id="app_members"></span>
                </div>
            </div>
        </div>

    </div>
</div>

{literal}
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const appInfo = document.getElementById("appInfo");
        const loader = document.getElementById("app_loader");

        function fetchServiceData() {
            loader.style.display = "flex";
            appInfo.style.display = "none";

            fetch("{/literal}{$url}{literal}&command=app_status")
                .then(response => response.json())
                .then(data => {
                    document.getElementById("app_version").innerText = `${data.version}`;
                    
                    // Находим владельца по service_username
                    const serviceUsername = "{/literal}{$service->service_username}{literal}";
                    const owner = data.members.find(member => member === serviceUsername) || 'N/A';
                    document.getElementById("app_owner").innerText = owner;

                    // Остальные пользователи (все кроме владельца)
                    const otherUsers = data.members.filter(member => member !== serviceUsername);
                    const membersList = otherUsers.join(', ');

                    // Show/hide users row based on whether there are additional users
                    const usersRow = document.querySelector('.users-row');
                    if (otherUsers.length === 0) {
                        usersRow.style.display = 'none';
                    } else {
                        usersRow.style.display = '';
                        document.getElementById("app_members").innerText = membersList;
                    }

                    loader.style.display = "none";
                    appInfo.style.display = "block";
                })
                .catch(error => {
                    console.error("Error fetching data: ", error);
                });
        }

        fetchServiceData();
    });



    window.addEventListener('load', function() {
        var passwordField = document.getElementById('password_input');
        const showPasswordButton = document.getElementById('showPasswordButton');


        function startShowPassword() {
            passwordField.type = 'text';
        }

        function endShowPassword() {
            passwordField.type = 'password';
        }

        showPasswordButton.addEventListener('mousedown', startShowPassword);
        showPasswordButton.addEventListener('mouseup', endShowPassword);
        showPasswordButton.addEventListener('mouseleave', endShowPassword);

        showPasswordButton.addEventListener('touchstart', startShowPassword);
        showPasswordButton.addEventListener('touchend', endShowPassword);
        showPasswordButton.addEventListener('touchcancel', endShowPassword);


    });
    function copyPassword() {
        const input = document.getElementById('password_input');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

    function copyServerLogin() {
        const input = document.getElementById('serverLogin');
        navigator.clipboard.writeText(input.value).then(() => {
            alert('Copied to clipboard: ' + input.value);
        }).catch(err => {
            console.error('Copy error: ', err);
        });
    }

</script>
{/literal}
