<div class="panel panel-default" style="margin-top: 8px;">
    <div class="panel-body" style="padding-top: 8px; padding-bottom: 5px;">

        <div id="loader" class="bloader" style="display: none;">
            <i class="fas fa-sync fa-spin fa-5x"></i>
        </div>

        <div id="serviceData">
            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <button id="refreshButton" type="button" class="btn btn-success btn-sm">
                        <i class="fas fa-sync"></i>
                    </button>
                    <b><i class="fa fa-status"></i>&nbsp;&nbsp;{$service->lang['Status']}:</b>
                </div>
                <div class="col-md-8">
                    <b id="statusText" class="text-success"></b>
                </div>
            </div>

            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-microchip"></i>&nbsp;&nbsp;{$service->lang['CPU usage']}:</b>
                </div>
                <div class="col-md-8">
                    <span id="cpuText"></span>
                    <div class="progress" style="margin-bottom: 10px; height: 20px;">
                        <div id="cpuRed" class="progress-bar" role="progressbar" style="width: 0%; background-color: red;"></div>
                        <div id="cpuGreen" class="progress-bar" role="progressbar" style="width: 100%; background-color: green;"></div>
                    </div>
                </div>
            </div>

            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-memory"></i>&nbsp;&nbsp;{$service->lang['Memory usage']}:</b>
                </div>
                <div class="col-md-8">
                    <span id="memoryText"></span>
                    <div class="progress" style="margin-bottom: 10px; height: 20px;">
                        <div id="memoryRed" class="progress-bar" role="progressbar" style="width: 0%; background-color: red;"></div>
                        <div id="memoryGreen" class="progress-bar" role="progressbar" style="width: 100%; background-color: green;"></div>
                    </div>
                </div>
            </div>

            <div class="row border-bottom">
                <div class="col-md-4 d-flex align-items-center">
                    <b><i class="fa fa-hdd"></i>&nbsp;&nbsp;{$service->lang['Disk usage']}:</b>
                </div>
                <div class="col-md-8">
                    <span id="diskText"></span>
                    <div class="progress" style="margin-bottom: 10px; height: 20px;">
                        <div id="diskRed" class="progress-bar" role="progressbar" style="width: 0%; background-color: red;"></div>
                        <div id="diskGreen" class="progress-bar" role="progressbar" style="width: 100%; background-color: green;"></div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

{literal}
<script>

    document.addEventListener("DOMContentLoaded", function () {
        const refreshButton = document.getElementById("refreshButton");
        const serviceData = document.getElementById("serviceData");
        const loader = document.getElementById("loader");

        function fetchServiceData() {
            loader.style.display = "flex";
            serviceData.style.display = "none";

            fetch("{/literal}{$url}{literal}&command=status")
                .then(response => response.json())
                .then(data => {
                    document.getElementById("statusText").innerText = data.status;
                    document.getElementById("cpuText").innerText = `${data.cpu.cores} CPU`;

                    let cpuUsed = data.cpu.usage;
                    let cpuFree = 100 - cpuUsed;
                    document.getElementById("cpuRed").style.width = cpuUsed + "%";
                    document.getElementById("cpuRed").innerText = cpuUsed + "%";

                    document.getElementById("cpuGreen").style.width = cpuFree + "%";
                    document.getElementById("cpuGreen").innerText = cpuFree + "%";

                    document.getElementById("memoryText").innerText = data.memory.used;
                    let memUsed = data.memory.percent;
                    let memFree = 100 - memUsed;
                    document.getElementById("memoryRed").style.width = memUsed + "%";
                    document.getElementById("memoryRed").innerText = memUsed + "%";

                    document.getElementById("memoryGreen").style.width = memFree + "%";
                    document.getElementById("memoryGreen").innerText = memFree + "%";

                    document.getElementById("diskText").innerText = `${data.disk.used} / ${data.disk.total}`;
                    let diskUsed = data.disk.percent;
                    let diskFree = 100 - diskUsed;
                    document.getElementById("diskRed").style.width = diskUsed + "%";
                    document.getElementById("diskRed").innerText = diskUsed + "%";

                    document.getElementById("diskGreen").style.width = diskFree + "%";
                    document.getElementById("diskGreen").innerText = diskFree + "%";

                    loader.style.display = "none";
                    serviceData.style.display = "block";
                })
                .catch(error => {
                    loader.style.display = "none";
                    serviceData.style.display = "block";
                });
        }

        refreshButton.addEventListener("click", function () {
            fetchServiceData();
        });

        fetchServiceData();
    });

</script>
{/literal}