{include file='modules/servers/puqDockerNextCloud/templates/header.tpl'}
<br>
<br>
<div class="form-group text-center">
    <h2>{$service->lang['IP Access Control']}</h2>
    <h3>{$service->lang['If IP is not specified, access is not limited']}</h3>
</div>

<div id="acl_loader" class="bloader" style="display: none; height: 300px;">
    <i class="fas fa-sync fa-spin fa-5x"></i>
</div>

<form id="ipAccessForm" name="ipAccessForm" style="display: none;" method="post" action="{$url}">
    <div class="row border-bottom">
        <div class="col-md-4 d-flex align-items-center">
            <b><i class="fa fa-users"></i>&nbsp;&nbsp;{$service->lang['WEB']}:</b>
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-10 d-flex align-items-center justify-content-center">
                    <strong>https://{$service->service_domain}</strong>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <textarea class="form-control" id="mainIPs" name="main_ips" rows="3"
                              placeholder="{$service->lang['Enter allowed IPs, one per line']}"></textarea>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col text-center">
            <button type="submit" name="submit" value="setACL" class="btn btn-primary"
                    form="ipAccessForm" id="setACLButton">
                <i class="fa fa-save"></i> {$service->lang['Save']}
            </button>
        </div>
    </div>
</form>

{literal}
<script>
    document.getElementById('setACLButton').addEventListener('click', function (event) {
        showLoader();
    });

    document.addEventListener("DOMContentLoaded", function () {
        const loader = document.getElementById("acl_loader");
        const form = document.getElementById("ipAccessForm");

        function fetchACLData() {
            loader.style.display = "flex";
            form.style.display = "none";

            fetch("{/literal}{$url}{literal}&command=acl")
                .then(response => response.json())
                .then(data => {
                    document.getElementById("mainIPs").value = data.main_ips.join('\n');
                    loader.style.display = "none";
                    form.style.display = "block";
                })
                .catch(error => {
                    console.error("Error fetching ACL data: ", error);
                    loader.style.display = "none";
                    form.style.display = "block";
                });
        }

        fetchACLData();
    });
</script>
{/literal}
