<style>
    #puq-groups-table {
        table-layout: fixed;
        width: 100%;
    }
    #puq-groups-table thead th {
        white-space: nowrap;
        vertical-align: middle;
        font-size: 12px;
        text-align: center;
    }
    #puq-groups-table tbody td {
        vertical-align: middle;
    }
    .puq-col-id { width: 40px; }
    .puq-col-name { width: 16%; }
    .puq-col-cnt { width: 35px; }
    .puq-col-chk { width: 50px; }
    .puq-col-tpl { }
    #puq-groups-table textarea.form-control {
        font-size: 12px;
        resize: vertical;
        min-height: 50px;
    }
    #puq-groups-table select.form-control {
        font-size: 11px;
        height: 26px;
        padding: 2px 6px;
        margin-bottom: 4px;
    }
    #puq-groups-table .puq-cell-id,
    #puq-groups-table .puq-cell-cnt {
        text-align: center;
        font-weight: 600;
        color: #555;
    }
    #puq-groups-table .puq-cell-name {
        font-weight: 600;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    #puq-groups-table .puq-cell-chk {
        text-align: center;
    }
    .puq-preview-btn {
        margin-top: 3px;
        font-size: 11px;
        opacity: 0.6;
    }
    .puq-preview-btn:hover {
        opacity: 1;
    }
    #puq-preview-content {
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 15px;
        background: #fafafa;
        min-height: 40px;
    }
</style>

<div class="row">
    <div class="col-md-12">

        <div class="clearfix" style="margin-bottom:15px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-paint-brush"></i> {$meta.lang['Label Designer']}
            </h1>

            <div class="pull-right">
                <input type="file" id="puq-import-file" style="display:none" accept=".json">
                <button type="button" class="btn btn-default" id="puq-import-btn" title="{$meta.lang['Import']}">
                    <i class="fa fa-upload"></i> {$meta.lang['Import']}
                </button>
                <button type="button" class="btn btn-default" id="puq-export-btn" title="{$meta.lang['Export']}">
                    <i class="fa fa-download"></i> {$meta.lang['Export']}
                </button>
                <button type="button" class="btn btn-success" id="puq-save-groups">
                    <i class="fa fa-save"></i> {$meta.lang['Save']}
                </button>
            </div>
        </div>

        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-info-circle"></i> {$meta.lang['Available Variables']}</h3>
            </div>
            <div class="panel-body">
                <code>{literal}{product-name}{/literal}</code> ,
                <code>{literal}{group-name}{/literal}</code> ,
                <code>{literal}{service-domain}{/literal}</code> ,
                <code>{literal}{service-username}{/literal}</code> ,
                <code>{literal}{service-dedicatedip}{/literal}</code> ,
                <code>{literal}{service-assignedips}{/literal}</code> ,
                <code>{literal}{service-id}{/literal}</code> ,
                <code>{literal}{service-status}{/literal}</code> ,
                <code>{literal}{service-regdate}{/literal}</code> ,
                <code>{literal}{service-nextduedate}{/literal}</code> ,
                <code>{literal}{client-name}{/literal}</code> ,
                <code>{literal}{client-email}{/literal}</code> ,
                <code>{literal}{service-customField-[name]}{/literal}</code> ,
                <code>{literal}{service-configOption-[name]}{/literal}</code>
            </div>
        </div>

        <div class="well well-sm" style="margin-bottom:10px;">
            <div class="btn-group btn-group-sm" style="margin-right:10px;">
                <button class="btn btn-default" id="puq-enable-all-list"><i class="fa fa-check"></i> {$meta.lang['Enable All List']}</button>
                <button class="btn btn-default" id="puq-disable-all-list"><i class="fa fa-times"></i> {$meta.lang['Disable All List']}</button>
            </div>
            <div class="btn-group btn-group-sm">
                <button class="btn btn-default" id="puq-enable-all-invoice"><i class="fa fa-check"></i> {$meta.lang['Enable All Invoice']}</button>
                <button class="btn btn-default" id="puq-disable-all-invoice"><i class="fa fa-times"></i> {$meta.lang['Disable All Invoice']}</button>
            </div>
        </div>

        <div class="panel panel-default" style="position: relative; min-height: 200px;">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-layer-group"></i> {$meta.lang['Label Designer']}</h3>
            </div>

            <div id="puq-groups-overlay" style="display:block;position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.9);z-index:9999;border-radius:4px;">
                <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);text-align:center;">
                    <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                    <div style="margin-top:10px;font-size:16px;">{$meta.lang['Loading...']}</div>
                </div>
            </div>

            <div class="table-responsive" style="margin:0;">
                <table class="table table-striped table-bordered" style="margin:0;" id="puq-groups-table">
                    <thead>
                        <tr>
                            <th class="puq-col-id">ID</th>
                            <th class="puq-col-name">{$meta.lang['Group Name']}</th>
                            <th class="puq-col-cnt"><i class="fa fa-cubes" title="{$meta.lang['Products']}"></i></th>
                            <th class="puq-col-chk"><i class="fa fa-list" title="{$meta.lang['Enable in List']}"></i></th>
                            <th class="puq-col-tpl">{$meta.lang['Overwrite List Text']}</th>
                            <th class="puq-col-chk"><i class="fa fa-file-invoice" title="{$meta.lang['Enable in Invoice']}"></i></th>
                            <th class="puq-col-tpl">{$meta.lang['Invoice Text']}</th>
                        </tr>
                    </thead>
                    <tbody id="puq-groups-body">
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<div class="modal fade" id="puq-preview-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-eye"></i> {$meta.lang['Preview']}</h4>
            </div>
            <div class="modal-body">
                <div id="puq-preview-info" class="text-muted" style="margin-bottom:8px; font-size:12px;"></div>
                <div id="puq-preview-content"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{$meta.lang['Close']}</button>
            </div>
        </div>
    </div>
</div>

{literal}
<script>
(function () {
    const baseUrl = '{/literal}{$meta.admin_module_url}{literal}&ajax=';

    function escHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function b64encode(str) {
        return btoa(unescape(encodeURIComponent(str)));
    }

    function loadGroups() {
        $.getJSON(baseUrl + 'getGroups', function (res) {
            if (!res || !res.success) {
                $('#puq-groups-overlay').hide();
                $('#puq-groups-body').html('<tr><td colspan="7" class="text-center text-muted" style="padding:30px;">{/literal}{$meta.lang['No groups found']}{literal}</td></tr>');
                return;
            }

            var groups = res.data || [];
            var html = '';

            if (groups.length === 0) {
                html = '<tr><td colspan="7" class="text-center text-muted" style="padding:30px;">{/literal}{$meta.lang['No groups found']}{literal}</td></tr>';
            } else {
                for (var i = 0; i < groups.length; i++) {
                    var g = groups[i];
                    var mode = g.invoice_mode || 'append';
                    html += '<tr>';
                    html += '<td class="puq-cell-id">' + g.id + '</td>';
                    html += '<td class="puq-cell-name" title="' + escHtml(g.group_name) + '">' + escHtml(g.group_name) + '</td>';
                    html += '<td class="puq-cell-cnt">' + g.product_count + '</td>';
                    html += '<td class="puq-cell-chk"><input type="checkbox" class="group-enable-list" data-id="' + g.id + '"' + (g.enable_list ? ' checked' : '') + '></td>';
                    html += '<td>';
                    html += '<textarea class="form-control group-overwrite-list" data-id="' + g.id + '" rows="2">' + escHtml(g.overwrite_list || '') + '</textarea>';
                    html += '<button class="btn btn-xs btn-default puq-preview-btn" data-id="' + g.id + '" data-type="list" title="{/literal}{$meta.lang['Preview']}{literal}"><i class="fa fa-eye"></i></button>';
                    html += '</td>';
                    html += '<td class="puq-cell-chk"><input type="checkbox" class="group-enable-invoice" data-id="' + g.id + '"' + (g.enable_invoice ? ' checked' : '') + '></td>';
                    html += '<td>';
                    html += '<select class="form-control group-invoice-mode" data-id="' + g.id + '">';
                    html += '<option value="append"' + (mode === 'append' ? ' selected' : '') + '>{/literal}{$meta.lang['Append']}{literal}</option>';
                    html += '<option value="replace"' + (mode === 'replace' ? ' selected' : '') + '>{/literal}{$meta.lang['Replace']}{literal}</option>';
                    html += '<option value="prepend"' + (mode === 'prepend' ? ' selected' : '') + '>{/literal}{$meta.lang['Prepend']}{literal}</option>';
                    html += '</select>';
                    html += '<textarea class="form-control group-invoice-text" data-id="' + g.id + '" rows="2">' + escHtml(g.invoice_text || '') + '</textarea>';
                    html += '<button class="btn btn-xs btn-default puq-preview-btn" data-id="' + g.id + '" data-type="invoice" title="{/literal}{$meta.lang['Preview']}{literal}"><i class="fa fa-eye"></i></button>';
                    html += '</td>';
                    html += '</tr>';
                }
            }

            $('#puq-groups-body').html(html);
            $('#puq-groups-overlay').hide();
        }).fail(function () {
            $('#puq-groups-overlay').hide();
        });
    }

    function collectGroups() {
        var groups = {};

        document.querySelectorAll('.group-overwrite-list').forEach(function (el) {
            var id = el.getAttribute('data-id');
            if (!groups[id]) groups[id] = {};
            groups[id].overwrite_list = el.value;
        });

        document.querySelectorAll('.group-invoice-text').forEach(function (el) {
            var id = el.getAttribute('data-id');
            if (!groups[id]) groups[id] = {};
            groups[id].invoice_text = el.value;
        });

        document.querySelectorAll('.group-enable-list').forEach(function (el) {
            var id = el.getAttribute('data-id');
            if (!groups[id]) groups[id] = {};
            groups[id].enable_list = el.checked ? 1 : 0;
        });

        document.querySelectorAll('.group-enable-invoice').forEach(function (el) {
            var id = el.getAttribute('data-id');
            if (!groups[id]) groups[id] = {};
            groups[id].enable_invoice = el.checked ? 1 : 0;
        });

        document.querySelectorAll('.group-invoice-mode').forEach(function (el) {
            var id = el.getAttribute('data-id');
            if (!groups[id]) groups[id] = {};
            groups[id].invoice_mode = el.value;
        });

        return groups;
    }

    $(document).ready(function () {
        loadGroups();

        // ---- Save ----
        $('#puq-save-groups').click(function () {
            var btn = $(this);
            var groups = collectGroups();

            btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ...');

            $.ajax({
                url: baseUrl + 'saveGroups',
                type: 'POST',
                data: { groups: b64encode(JSON.stringify(groups)) },
                dataType: 'json',
                success: function (res) {
                    btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang['Save']}{literal}');

                    if (res && res.success) {
                        showNotification(res.message || 'Groups saved', 'success');
                        $('#puq-groups-overlay').show();
                        loadGroups();
                    } else {
                        showNotification(res.error || res.message || 'Error saving groups', 'error');
                    }
                },
                error: function (xhr) {
                    btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang['Save']}{literal}');

                    var msg = 'Server error: ' + xhr.status;
                    try {
                        var r = JSON.parse(xhr.responseText);
                        if (r && r.error) msg = r.error;
                    } catch (e) {}
                    showNotification(msg, 'error');
                }
            });
        });

        // ---- Preview ----
        $(document).on('click', '.puq-preview-btn', function () {
            var btn = $(this);
            var groupId = btn.data('id');
            var type = btn.data('type');
            var textarea;

            if (type === 'list') {
                textarea = btn.closest('td').find('.group-overwrite-list');
            } else {
                textarea = btn.closest('td').find('.group-invoice-text');
            }

            var template = textarea.val();
            if (!template || template.trim() === '') {
                showNotification('{/literal}{$meta.lang['Template is empty']}{literal}', 'error');
                return;
            }

            btn.prop('disabled', true).find('i').removeClass('fa-eye').addClass('fa-spinner fa-spin');

            $.ajax({
                url: baseUrl + 'previewTemplate',
                type: 'POST',
                data: { group_id: groupId, template: b64encode(template) },
                dataType: 'json',
                success: function (res) {
                    btn.prop('disabled', false).find('i').removeClass('fa-spinner fa-spin').addClass('fa-eye');

                    if (res && res.success) {
                        $('#puq-preview-info').html('Service ID: ' + res.data.service_id);
                        $('#puq-preview-content').html(res.data.html);
                        $('#puq-preview-modal').modal('show');
                    } else {
                        showNotification(res.error || 'Preview error', 'error');
                    }
                },
                error: function () {
                    btn.prop('disabled', false).find('i').removeClass('fa-spinner fa-spin').addClass('fa-eye');
                    showNotification('Server error', 'error');
                }
            });
        });

        // ---- Bulk operations ----
        $('#puq-enable-all-list').click(function () {
            $('.group-enable-list').prop('checked', true);
        });
        $('#puq-disable-all-list').click(function () {
            $('.group-enable-list').prop('checked', false);
        });
        $('#puq-enable-all-invoice').click(function () {
            $('.group-enable-invoice').prop('checked', true);
        });
        $('#puq-disable-all-invoice').click(function () {
            $('.group-enable-invoice').prop('checked', false);
        });

        // ---- Export ----
        $('#puq-export-btn').click(function () {
            var btn = $(this);
            btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ...');

            $.getJSON(baseUrl + 'exportAll', function (res) {
                btn.prop('disabled', false).html('<i class="fa fa-download"></i> {/literal}{$meta.lang['Export']}{literal}');

                if (res && res.success) {
                    var blob = new Blob([JSON.stringify(res.data, null, 2)], { type: 'application/json' });
                    var url = URL.createObjectURL(blob);
                    var a = document.createElement('a');
                    a.href = url;
                    a.download = 'service_label_designer_export.json';
                    a.click();
                    URL.revokeObjectURL(url);
                    showNotification('{/literal}{$meta.lang['Export successful']}{literal}', 'success');
                } else {
                    showNotification(res.error || 'Export failed', 'error');
                }
            }).fail(function () {
                btn.prop('disabled', false).html('<i class="fa fa-download"></i> {/literal}{$meta.lang['Export']}{literal}');
                showNotification('Server error', 'error');
            });
        });

        // ---- Import ----
        $('#puq-import-btn').click(function () {
            $('#puq-import-file').click();
        });

        $('#puq-import-file').change(function () {
            var file = this.files[0];
            if (!file) return;

            var reader = new FileReader();
            reader.onload = function (e) {
                var btn = $('#puq-import-btn');
                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ...');

                $.ajax({
                    url: baseUrl + 'importAll',
                    type: 'POST',
                    data: { data: b64encode(e.target.result) },
                    dataType: 'json',
                    success: function (res) {
                        btn.prop('disabled', false).html('<i class="fa fa-upload"></i> {/literal}{$meta.lang['Import']}{literal}');

                        if (res && res.success) {
                            showNotification(res.message || '{/literal}{$meta.lang['Import successful']}{literal}', 'success');
                            $('#puq-groups-overlay').show();
                            loadGroups();
                        } else {
                            showNotification(res.error || 'Import failed', 'error');
                        }
                    },
                    error: function () {
                        btn.prop('disabled', false).html('<i class="fa fa-upload"></i> {/literal}{$meta.lang['Import']}{literal}');
                        showNotification('Server error', 'error');
                    }
                });
            };
            reader.readAsText(file);
            this.value = '';
        });
    });
})();
</script>
{/literal}
