<div class="row">
    <div class="col-md-12">

        <div class="clearfix" style="margin-bottom:15px;">
            <h1 class="pull-left" style="margin:0;">
                <i class="fa fa-cog"></i> {$meta.lang['Configuration']}
            </h1>

            <div class="pull-right">
                <button type="submit" form="puq-settings-form" class="btn btn-success" id="puq-save-settings">
                    <i class="fa fa-save"></i> {$meta.lang['Save']}
                </button>
            </div>
        </div>

        <form id="puq-settings-form" style="position: relative;">

            <div id="puq-settings-overlay" style="display:block;position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.9);z-index:9999;border-radius:4px;">
                <div style="position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);text-align:center;">
                    <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                    <div style="margin-top:10px;font-size:16px;">{$meta.lang['Loading...']}</div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-7">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"><i class="fa fa-cog"></i> {$meta.lang['Default Values']}</h3>
                        </div>
                        <div class="panel-body">

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Product Name']}</label>
                                <input type="text" name="default-product-name" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Group Name']}</label>
                                <input type="text" name="default-group-name" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Service Domain']}</label>
                                <input type="text" name="default-service-domain" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Service Username']}</label>
                                <input type="text" name="default-service-username" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Service Dedicated IP']}</label>
                                <input type="text" name="default-service-dedicatedip" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Service Assigned IPs']}</label>
                                <input type="text" name="default-service-assignedips" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Custom Field']}</label>
                                <input type="text" name="default-service-customField" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="control-label">{$meta.lang['Default Config Option']}</label>
                                <input type="text" name="default-service-configOption" class="form-control">
                            </div>

                        </div>
                    </div>
                </div>

                <div class="col-md-5">
                    <div class="panel panel-info">
                        <div class="panel-heading">
                            <h3 class="panel-title"><i class="fa fa-info-circle"></i> {$meta.lang['Available Variables']}</h3>
                        </div>
                        <div class="panel-body" style="padding:0;">
                            <table class="table table-striped table-condensed" style="margin:0;">
                                <thead>
                                    <tr>
                                        <th>{$meta.lang['Variable']}</th>
                                        <th>{$meta.lang['Description']}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr><td><code>{literal}{product-name}{/literal}</code></td><td>{$meta.lang['var_product_name']}</td></tr>
                                    <tr><td><code>{literal}{group-name}{/literal}</code></td><td>{$meta.lang['var_group_name']}</td></tr>
                                    <tr><td><code>{literal}{service-domain}{/literal}</code></td><td>{$meta.lang['var_service_domain']}</td></tr>
                                    <tr><td><code>{literal}{service-username}{/literal}</code></td><td>{$meta.lang['var_service_username']}</td></tr>
                                    <tr><td><code>{literal}{service-dedicatedip}{/literal}</code></td><td>{$meta.lang['var_service_dedicatedip']}</td></tr>
                                    <tr><td><code>{literal}{service-assignedips}{/literal}</code></td><td>{$meta.lang['var_service_assignedips']}</td></tr>
                                    <tr><td><code>{literal}{service-id}{/literal}</code></td><td>{$meta.lang['var_service_id']}</td></tr>
                                    <tr><td><code>{literal}{service-status}{/literal}</code></td><td>{$meta.lang['var_service_status']}</td></tr>
                                    <tr><td><code>{literal}{service-regdate}{/literal}</code></td><td>{$meta.lang['var_service_regdate']}</td></tr>
                                    <tr><td><code>{literal}{service-nextduedate}{/literal}</code></td><td>{$meta.lang['var_service_nextduedate']}</td></tr>
                                    <tr><td><code>{literal}{client-name}{/literal}</code></td><td>{$meta.lang['var_client_name']}</td></tr>
                                    <tr><td><code>{literal}{client-email}{/literal}</code></td><td>{$meta.lang['var_client_email']}</td></tr>
                                    <tr><td><code>{literal}{service-customField-[name]}{/literal}</code></td><td>{$meta.lang['var_service_customField']}</td></tr>
                                    <tr><td><code>{literal}{service-configOption-[name]}{/literal}</code></td><td>{$meta.lang['var_service_configOption']}</td></tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
</div>

{literal}
<script>
(function () {
    const baseUrl = '{/literal}{$meta.admin_module_url}{literal}&ajax=';

    function loadSettings() {
        $.getJSON(baseUrl + 'getSettings', function (res) {
            if (!res || !res.success) {
                $('#puq-settings-overlay').hide();
                return;
            }

            var s = res.data.settings || {};
            var form = $('#puq-settings-form');

            $.each(s, function (key, val) {
                var el = form.find('[name="' + key + '"]');
                if (el.length && val !== null && val !== undefined) {
                    el.val(String(val));
                }
            });

            $('#puq-settings-overlay').hide();
        }).fail(function () {
            $('#puq-settings-overlay').hide();
        });
    }

    $(document).ready(function () {
        loadSettings();

        $('#puq-settings-form').submit(function (e) {
            e.preventDefault();

            var form = $(this);
            var btn = $('#puq-save-settings');

            btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> ...');

            $.ajax({
                url: baseUrl + 'saveSettings',
                type: 'POST',
                data: form.serializeArray(),
                dataType: 'json',
                success: function (res) {
                    btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang['Save']}{literal}');

                    if (res && res.success) {
                        showNotification(res.message || 'Settings saved', 'success');
                        $('#puq-settings-overlay').show();
                        loadSettings();
                    } else {
                        showNotification(res.error || res.message || 'Error saving settings', 'error');
                    }
                },
                error: function (xhr) {
                    btn.prop('disabled', false).html('<i class="fa fa-save"></i> {/literal}{$meta.lang['Save']}{literal}');

                    var msg = 'Server error: ' + xhr.status;
                    try {
                        var r = JSON.parse(xhr.responseText);
                        if (r && r.error) msg = r.error;
                    } catch (e) {}
                    showNotification(msg, 'error');
                }
            });
        });
    });
})();
</script>
{/literal}
