
<style>
    .license-block {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
        background: #ffffff;
        padding: 40px 20px;
    }

    .license-container {
        text-align: center;
        z-index: 10;
        position: relative;
    }

    .license-icon-wrapper {
        margin-bottom: 30px;
    }

    .license-icon {
        font-size: 140px;
        color: #d9534f;
        position: relative;
        text-shadow: 0 0 20px rgba(217, 83, 79, 0.3);
        animation: license-pulse 2s ease-in-out infinite;
        line-height: 1;
    }

    @keyframes license-pulse {
        0%, 100% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.05); opacity: 0.85; }
    }

    .license-title {
        font-size: 48px;
        color: #2d3748;
        margin: 20px 0;
        font-weight: 700;
    }

    .license-description {
        font-size: 18px;
        color: #718096;
        margin-bottom: 15px;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }

    .license-hint {
        font-size: 14px;
        color: #a0aec0;
        margin-bottom: 40px;
    }

    .btn-license {
        display: inline-block;
        padding: 15px 40px;
        background: #d9534f;
        color: #fff;
        text-decoration: none;
        border-radius: 50px;
        font-size: 16px;
        font-weight: 600;
        border: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(217, 83, 79, 0.3);
        margin: 0 8px;
    }

    .btn-license:hover {
        background: #c9302c;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(217, 83, 79, 0.4);
        color: #fff;
        text-decoration: none;
    }

    .btn-license i {
        margin-right: 8px;
    }

    .btn-home-link {
        display: inline-block;
        padding: 15px 40px;
        background: #667eea;
        color: #fff;
        text-decoration: none;
        border-radius: 50px;
        font-size: 16px;
        font-weight: 600;
        border: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        margin: 0 8px;
    }

    .btn-home-link:hover {
        background: #5568d3;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        color: #fff;
        text-decoration: none;
    }

    .btn-home-link i {
        margin-right: 8px;
    }

    @media (max-width: 768px) {
        .license-icon {
            font-size: 100px;
        }
        .license-title {
            font-size: 32px;
        }
        .license-description {
            font-size: 16px;
            padding: 0 20px;
        }
    }
</style>

<div class="license-block">
    <div class="license-container">
        <div class="license-icon-wrapper">
            <div class="license-icon"><i class="fa fa-lock"></i></div>
        </div>
        <h1 class="license-title">{$meta.lang['License Required']}</h1>
        <p class="license-description">{$meta.lang['License required page description']}</p>
        <p class="license-hint">{$meta.lang['License required page hint']}</p>
        <div>
            <a href="{$meta.url_purchase_license}" target="_blank" class="btn-license">
                <i class="fa fa-shopping-cart"></i> {$meta.lang['Purchase License']}
            </a>
            <a href="{$meta.admin_module_url}&page=home" class="btn-home-link">
                <i class="fa fa-home"></i> {$meta.lang['Home']}
            </a>
        </div>
    </div>
</div>
