<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-paint-brush"></i> {$meta.lang['Dashboard']}</h1>
        <p class="text-muted">{$meta.lang['Module Description']}</p>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="dash-counts"></div>
    <div id="dash-enabled-groups"></div>
    <div id="dash-recent-previews"></div>
</div>

<style>
    .dash-stat {
        text-align: center;
        padding: 18px 10px;
    }
    .dash-stat-value {
        font-size: 32px;
        font-weight: bold;
        line-height: 1.1;
    }
    .dash-stat-label {
        margin-top: 6px;
        color: #888;
        font-size: 13px;
    }
    .dash-badge {
        display: inline-block;
        padding: 2px 8px;
        border-radius: 3px;
        font-size: 11px;
        font-weight: 600;
        color: #fff;
    }
    .dash-badge-list { background: #5bc0de; }
    .dash-badge-invoice { background: #f0ad4e; }
    .dash-badge-mode { background: #777; font-weight: normal; }
    .dash-template-preview {
        font-size: 11px;
        color: #999;
        max-width: 300px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .dash-rendered {
        background: #f9f9f9;
        border: 1px solid #eee;
        border-radius: 3px;
        padding: 6px 10px;
        font-size: 12px;
        max-width: 400px;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getDashboard';

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';

            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }

            var d = response.data;
            renderCounts(d);
            renderEnabledGroups(d);
            renderRecentPreviews(d);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load dashboard data', 'error');
        }
    });

    function escHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function renderCounts(d) {
        var cards = [
            { value: d.total_groups, label: '{/literal}{$meta.lang['Total Groups']}{literal}', icon: 'fa-layer-group', color: '#5bc0de' },
            { value: d.total_products, label: '{/literal}{$meta.lang['Total Products']}{literal}', icon: 'fa-cubes', color: '#337ab7' },
            { value: d.active_services, label: '{/literal}{$meta.lang['Active Services']}{literal}', icon: 'fa-check-circle', color: '#5cb85c' },
            { value: d.groups_enabled_list, label: '{/literal}{$meta.lang['Groups List Enabled']}{literal}', icon: 'fa-list', color: '#f0ad4e' },
            { value: d.groups_enabled_invoice, label: '{/literal}{$meta.lang['Groups Invoice Enabled']}{literal}', icon: 'fa-file-invoice', color: '#d9534f' },
        ];

        var html = '<div class="row" style="margin-top:10px;">';
        for (var i = 0; i < cards.length; i++) {
            var c = cards[i];
            html += '<div class="col-lg-' + (i < 3 ? '4' : '6') + ' col-md-6 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid ' + c.color + ';">';
            html += '<div class="dash-stat">';
            html += '<div class="dash-stat-value" style="color:' + c.color + ';">' + c.value + '</div>';
            html += '<div class="dash-stat-label"><i class="fa ' + c.icon + '"></i> ' + c.label + '</div>';
            html += '</div></div></div>';
            if (i === 2) html += '</div><div class="row">';
        }
        html += '</div>';
        document.getElementById('dash-counts').innerHTML = html;
    }

    function renderEnabledGroups(d) {
        var groups = d.enabled_groups || [];
        if (groups.length === 0) return;

        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-toggle-on"></i> {/literal}{$meta.lang['Enabled Groups']}{literal}</h3></div>';
        html += '<div class="table-responsive" style="margin:0;"><table class="table table-striped table-condensed" style="margin:0;">';
        html += '<thead><tr>';
        html += '<th style="width:40px;">ID</th>';
        html += '<th>{/literal}{$meta.lang['Group Name']}{literal}</th>';
        html += '<th style="width:80px;text-align:center;">{/literal}{$meta.lang['Active Services']}{literal}</th>';
        html += '<th style="width:130px;text-align:center;">{/literal}{$meta.lang['Status']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['List Template']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Invoice Template']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < groups.length; i++) {
            var g = groups[i];
            html += '<tr>';
            html += '<td style="text-align:center;color:#888;">' + g.id + '</td>';
            html += '<td><strong>' + escHtml(g.group_name) + '</strong></td>';
            html += '<td style="text-align:center;">' + g.active_services_count + '</td>';
            html += '<td style="text-align:center;">';
            if (g.enable_list) html += '<span class="dash-badge dash-badge-list">List</span> ';
            if (g.enable_invoice) {
                html += '<span class="dash-badge dash-badge-invoice">Invoice</span> ';
                var mode = g.invoice_mode || 'append';
                html += '<span class="dash-badge dash-badge-mode">' + mode + '</span>';
            }
            html += '</td>';
            html += '<td class="dash-template-preview" title="' + escHtml(g.overwrite_list || '') + '">' + escHtml(g.overwrite_list || '-') + '</td>';
            html += '<td class="dash-template-preview" title="' + escHtml(g.invoice_text || '') + '">' + escHtml(g.invoice_text || '-') + '</td>';
            html += '</tr>';
        }

        html += '</tbody></table></div></div></div></div>';
        document.getElementById('dash-enabled-groups').innerHTML = html;
    }

    function renderRecentPreviews(d) {
        var previews = d.recent_previews || [];
        if (previews.length === 0) return;

        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-eye"></i> {/literal}{$meta.lang['Recent Services Preview']}{literal}</h3></div>';
        html += '<div class="table-responsive" style="margin:0;"><table class="table table-striped table-condensed" style="margin:0;">';
        html += '<thead><tr>';
        html += '<th style="width:40px;">ID</th>';
        html += '<th>{/literal}{$meta.lang['Product']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Client']}{literal}</th>';
        html += '<th>{/literal}{$meta.lang['Rendered Label']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < previews.length; i++) {
            var p = previews[i];
            html += '<tr>';
            html += '<td style="text-align:center;color:#888;">' + p.service_id + '</td>';
            html += '<td>' + escHtml(p.product_name) + ' <span style="color:#aaa;">/ ' + escHtml(p.group_name) + '</span></td>';
            html += '<td>' + escHtml(p.client) + '</td>';
            html += '<td><div class="dash-rendered">' + (p.rendered || '<span class="text-muted">-</span>') + '</div></td>';
            html += '</tr>';
        }

        html += '</tbody></table></div></div></div></div>';
        document.getElementById('dash-recent-previews').innerHTML = html;
    }
});
</script>
{/literal}
