<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-star"></i> {$meta.lang['Product Popularity']}</h1>
        <p class="text-muted">{$meta.lang['Product Popularity Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:10px;">
    <div class="col-md-12">
        <div class="btn-group" id="range-buttons">
            <button type="button" class="btn btn-default" data-range="this_month">{$meta.lang['This Month']}</button>
            <button type="button" class="btn btn-default" data-range="this_year">{$meta.lang['This Year']}</button>
            <button type="button" class="btn btn-default" data-range="last_30_days">{$meta.lang['Last 30 Days']}</button>
            <button type="button" class="btn btn-default active" data-range="last_12_months">{$meta.lang['Last 12 Months']}</button>
            <button type="button" class="btn btn-default" data-range="last_2_years">{$meta.lang['Last 2 Years']}</button>
            <button type="button" class="btn btn-default" data-range="all_time">{$meta.lang['All Time']}</button>
        </div>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="chart-section"></div>
    <div id="table-section"></div>
</div>

<style>
    #range-buttons .btn.active {
        background-color: #337ab7;
        color: #fff;
        border-color: #2e6da4;
    }
    .hbar-row {
        display: flex;
        align-items: center;
        margin-bottom: 6px;
    }
    .hbar-label {
        width: 200px;
        min-width: 200px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .hbar-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 22px;
        overflow: hidden;
    }
    .hbar-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .hbar-value {
        width: 70px;
        min-width: 70px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    .chart-bar-row {
        display: flex;
        align-items: flex-end;
        height: 160px;
        padding: 0 5px;
        gap: 3px;
    }
    .chart-bar-col {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 28px;
    }
    .chart-bar {
        width: 100%;
        max-width: 50px;
        border-radius: 3px 3px 0 0;
        min-height: 2px;
        transition: height 0.3s;
        cursor: default;
    }
    .chart-bar:hover { opacity: 0.8; }
    .chart-label {
        font-size: 10px;
        color: #999;
        margin-top: 6px;
        text-align: center;
    }
    .chart-value {
        font-size: 10px;
        font-weight: bold;
        color: #555;
        margin-bottom: 3px;
    }
    #pop-table td,
    #pop-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var baseUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getProductsPopularity';
    var currentRange = 'last_12_months';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery('#range-buttons .btn').on('click', function() {
        jQuery('#range-buttons .btn').removeClass('active');
        jQuery(this).addClass('active');
        currentRange = jQuery(this).data('range');
        loadData(currentRange);
    });

    function showLoading() {
        document.getElementById('main-loading').style.display = 'block';
        document.getElementById('summary-cards').innerHTML = '';
        document.getElementById('chart-section').innerHTML = '';
        document.getElementById('table-section').innerHTML = '';
        if (jQuery.fn.DataTable.isDataTable('#pop-table')) {
            jQuery('#pop-table').DataTable().destroy();
        }
    }

    function loadData(range) {
        showLoading();

        jQuery.ajax({
            url: baseUrl + '&range=' + range,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';

                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }

                var summary = response.data.summary;
                var products = response.data.products;
                var monthly = response.data.monthly;

                if (!summary || summary.length === 0) {
                    document.getElementById('summary-cards').innerHTML =
                        '<div class="row"><div class="col-md-12"><div class="alert alert-info" style="margin-top:15px;"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No products found']}{literal}</div></div></div>';
                    return;
                }

                renderSummary(summary);
                renderMonthlyCharts(monthly);
                renderTopChart(products);
                renderTable(products);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('Failed to load data', 'error');
            }
        });
    }

    function renderSummary(summary) {
        var html = '';
        for (var i = 0; i < summary.length; i++) {
            var s = summary[i];
            html += '<div class="row" style="margin-top:10px;">';

            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#337ab7;">' + s.new + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-plus-circle"></i> {/literal}{$meta.lang['New Subscriptions']}{literal}</div>';
            html += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(s.currency_code) + '</div>';
            html += '</div></div></div>';

            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#5cb85c;">' + s.active + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-check-circle"></i> {/literal}{$meta.lang['Still Active']}{literal}</div>';
            html += '</div></div></div>';

            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #d9534f;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#d9534f;">' + s.churned + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-times-circle"></i> {/literal}{$meta.lang['Churned']}{literal}</div>';
            html += '</div></div></div>';

            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #f0ad4e;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#f0ad4e;">' + formatMoney(s.currency_prefix, s.revenue, s.currency_suffix) + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-dollar-sign"></i> {/literal}{$meta.lang['Revenue in Period']}{literal}</div>';
            html += '</div></div></div>';

            html += '</div>';
        }
        document.getElementById('summary-cards').innerHTML = html;
    }

    function renderMonthlyCharts(monthly) {
        if (!monthly || monthly.length === 0) return;

        var html = '';
        for (var c = 0; c < monthly.length; c++) {
            var cur = monthly[c];
            var months = cur.months;
            if (months.length === 0) continue;

            // New Subscriptions chart
            var maxNew = 0;
            for (var m = 0; m < months.length; m++) {
                if (months[m].new > maxNew) maxNew = months[m].new;
            }
            if (maxNew === 0) maxNew = 1;

            html += '<div class="row" style="margin-top:10px;">';
            html += '<div class="col-md-6">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['New Subscriptions per Month']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            html += '<div class="panel-body" style="overflow-x:auto;">';
            html += '<div class="chart-bar-row">';
            for (var m = 0; m < months.length; m++) {
                var h = Math.max((months[m].new / maxNew) * 150, 2);
                var label = months[m].month.substring(2);
                html += '<div class="chart-bar-col">';
                html += '<div class="chart-value">' + months[m].new + '</div>';
                html += '<div class="chart-bar" style="height:' + h + 'px; background:#337ab7;" title="' + months[m].month + ': ' + months[m].new + '"></div>';
                html += '<div class="chart-label">' + label + '</div>';
                html += '</div>';
            }
            html += '</div></div></div></div>';

            // Revenue chart
            var maxRev = 0;
            for (var m = 0; m < months.length; m++) {
                if (months[m].revenue > maxRev) maxRev = months[m].revenue;
            }
            if (maxRev === 0) maxRev = 1;

            html += '<div class="col-md-6">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['Revenue per Month']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            html += '<div class="panel-body" style="overflow-x:auto;">';
            html += '<div class="chart-bar-row">';
            for (var m = 0; m < months.length; m++) {
                var h = Math.max((months[m].revenue / maxRev) * 150, 2);
                var label = months[m].month.substring(2);
                html += '<div class="chart-bar-col">';
                html += '<div class="chart-value">' + formatMoney(cur.currency_prefix, months[m].revenue, cur.currency_suffix) + '</div>';
                html += '<div class="chart-bar" style="height:' + h + 'px; background:#f0ad4e;" title="' + months[m].month + ': ' + formatMoney(cur.currency_prefix, months[m].revenue, cur.currency_suffix) + '"></div>';
                html += '<div class="chart-label">' + label + '</div>';
                html += '</div>';
            }
            html += '</div></div></div>';
            html += '</div>';
        }
        document.getElementById('chart-section').innerHTML = html;
    }

    function renderTopChart(products) {
        if (!products || products.length === 0) return;

        var byCurrency = {};
        for (var i = 0; i < products.length; i++) {
            var p = products[i];
            if (!byCurrency[p.currency_code]) {
                byCurrency[p.currency_code] = {
                    currency_code: p.currency_code,
                    currency_prefix: p.currency_prefix,
                    currency_suffix: p.currency_suffix,
                    items: []
                };
            }
            byCurrency[p.currency_code].items.push(p);
        }

        var colors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f', '#9b59b6', '#1abc9c', '#e67e22', '#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#8e44ad', '#16a085', '#c0392b'];
        var html = '';

        for (var code in byCurrency) {
            var cur = byCurrency[code];
            var items = cur.items.slice(0, 15);
            var maxVal = 0;
            for (var j = 0; j < items.length; j++) {
                if (items[j].revenue > maxVal) maxVal = items[j].revenue;
            }
            if (maxVal === 0) maxVal = 1;

            html += '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-star"></i> {/literal}{$meta.lang['Top Products']}{literal} <span class="label label-info">' + escapeHtml(code) + '</span></h3></div>';
            html += '<div class="panel-body">';

            for (var j = 0; j < items.length; j++) {
                var it = items[j];
                var pct = (it.revenue / maxVal) * 100;
                var color = colors[j % colors.length];
                html += '<div class="hbar-row">';
                html += '<div class="hbar-label" title="' + escapeHtml(it.product_name) + '">' + escapeHtml(it.product_name) + '</div>';
                html += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pct + '%; background:' + color + ';"></div></div>';
                html += '<div class="hbar-value">' + formatMoney(cur.currency_prefix, it.revenue, cur.currency_suffix) + '</div>';
                html += '</div>';
            }

            html += '</div></div></div></div>';
        }

        document.getElementById('chart-section').innerHTML += html;
    }

    function renderTable(products) {
        if (!products || products.length === 0) return;

        var html = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-table"></i> {/literal}{$meta.lang['Product Popularity']}{literal}</h3></div>';
        html += '<div class="panel-body"><div class="table-responsive">';
        html += '<table class="table table-striped table-hover" id="pop-table" style="width:100%; table-layout:fixed;">';
        html += '<thead><tr>';
        html += '<th style="width:25%;">{/literal}{$meta.lang['Product Name']}{literal}</th>';
        html += '<th style="width:15%;">{/literal}{$meta.lang['Group']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Currency']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['New']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Active']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Churned']}{literal}</th>';
        html += '<th style="width:80px;">{/literal}{$meta.lang['Suspended']}{literal}</th>';
        html += '<th style="width:14%;">{/literal}{$meta.lang['Revenue in Period']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < products.length; i++) {
            var p = products[i];
            html += '<tr>';
            html += '<td>' + escapeHtml(p.product_name) + '</td>';
            html += '<td>' + escapeHtml(p.group_name) + '</td>';
            html += '<td><span class="label label-info">' + escapeHtml(p.currency_code) + '</span></td>';
            html += '<td data-order="' + p.new + '"><span class="label label-primary">' + p.new + '</span></td>';
            html += '<td data-order="' + p.active + '"><span class="label label-success">' + p.active + '</span></td>';
            html += '<td data-order="' + p.churned + '"><span class="label label-danger">' + p.churned + '</span></td>';
            html += '<td data-order="' + p.suspended + '"><span class="label label-warning">' + p.suspended + '</span></td>';
            html += '<td data-order="' + p.revenue + '" style="text-align:right; font-weight:bold; color:#5cb85c;">' + formatMoney(p.currency_prefix, p.revenue, p.currency_suffix) + '</td>';
            html += '</tr>';
        }

        html += '</tbody></table></div></div></div></div></div>';
        document.getElementById('table-section').innerHTML = html;

        jQuery('#pop-table').DataTable({
            order: [[7, 'desc']],
            paging: false,
            autoWidth: false
        });
    }

    loadData(currentRange);
});
</script>
{/literal}