<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-user-minus"></i> {$meta.lang['Product Churn']}</h1>
        <p class="text-muted">{$meta.lang['Product Churn Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #d9534f;">
            <div class="panel-body text-center">
                <div id="stat-churn-rate" style="font-size:32px; font-weight:bold; color:#d9534f;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-percentage"></i> {$meta.lang['Churn Rate']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #5cb85c;">
            <div class="panel-body text-center">
                <div id="stat-retention-rate" style="font-size:32px; font-weight:bold; color:#5cb85c;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-shield-alt"></i> {$meta.lang['Retention Rate']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #f0ad4e;">
            <div class="panel-body text-center">
                <div id="stat-churned" style="font-size:32px; font-weight:bold; color:#f0ad4e;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-user-minus"></i> {$meta.lang['Churned Services']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #f0ad4e;">
            <div class="panel-body text-center">
                <div id="stat-suspended" style="font-size:32px; font-weight:bold; color:#f0ad4e;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-pause-circle"></i> {$meta.lang['At Risk (Suspended)']}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-user-minus"></i> {$meta.lang['Churn by Product']}</h3>
            </div>
            <div class="panel-body">
                <div class="text-center" id="churn-loading" style="padding:40px 0;">
                    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
                    <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
                </div>
                <div class="table-responsive" id="churn-table-wrapper" style="display:none;">
                    <table class="table table-striped table-hover" id="churn-table" style="width:100%; table-layout:fixed;">
                        <thead>
                            <tr>
                                <th style="width:30%;">{$meta.lang['Product Name']}</th>
                                <th style="width:70px;">{$meta.lang['Total']}</th>
                                <th style="width:70px;">{$meta.lang['Active']}</th>
                                <th style="width:70px;">{$meta.lang['Suspended']}</th>
                                <th style="width:70px;">{$meta.lang['Churned']}</th>
                                <th style="width:120px;">{$meta.lang['Churn Rate']}</th>
                                <th style="width:120px;">{$meta.lang['Retention Rate']}</th>
                            </tr>
                        </thead>
                        <tbody id="churn-tbody">
                        </tbody>
                    </table>
                </div>
                <div class="alert alert-info" id="churn-empty" style="display:none;">
                    <i class="fa fa-info-circle"></i> {$meta.lang['No churn data']}
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    #churn-table td,
    #churn-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
    .churn-bar {
        height: 8px;
        border-radius: 4px;
        background: #eee;
        margin-top: 4px;
        overflow: hidden;
    }
    .churn-bar-fill {
        height: 100%;
        border-radius: 4px;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getProductsChurn';

    function churnColor(rate) {
        if (rate >= 50) return '#d9534f';
        if (rate >= 25) return '#f0ad4e';
        if (rate >= 10) return '#f0c866';
        return '#5cb85c';
    }

    function retentionColor(rate) {
        if (rate >= 75) return '#5cb85c';
        if (rate >= 50) return '#f0c866';
        if (rate >= 25) return '#f0ad4e';
        return '#d9534f';
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                var s = response.data.summary;
                document.getElementById('stat-churn-rate').innerHTML = s.churn_rate + '<small style="font-size:16px;">%</small>';
                document.getElementById('stat-retention-rate').innerHTML = s.retention_rate + '<small style="font-size:16px;">%</small>';
                document.getElementById('stat-churned').textContent = s.churned;
                document.getElementById('stat-suspended').textContent = s.suspended;

                var products = response.data.products;
                document.getElementById('churn-loading').style.display = 'none';

                if (products.length === 0) {
                    document.getElementById('churn-empty').style.display = 'block';
                    return;
                }

                var tbody = document.getElementById('churn-tbody');
                var html = '';
                for (var i = 0; i < products.length; i++) {
                    var p = products[i];
                    var cc = churnColor(p.churn_rate);
                    var rc = retentionColor(p.retention_rate);

                    html += '<tr>';
                    html += '<td>' + escapeHtml(p.name) + '</td>';
                    html += '<td><strong>' + p.total + '</strong></td>';
                    html += '<td data-order="' + p.active + '"><span class="label label-success">' + p.active + '</span></td>';
                    html += '<td data-order="' + p.suspended + '"><span class="label label-warning">' + p.suspended + '</span></td>';
                    html += '<td data-order="' + p.churned + '"><span class="label label-danger">' + p.churned + '</span></td>';
                    html += '<td data-order="' + p.churn_rate + '">';
                    html += '<strong style="color:' + cc + ';">' + p.churn_rate + '%</strong>';
                    html += '<div class="churn-bar"><div class="churn-bar-fill" style="width:' + Math.min(p.churn_rate, 100) + '%; background:' + cc + ';"></div></div>';
                    html += '</td>';
                    html += '<td data-order="' + p.retention_rate + '">';
                    html += '<strong style="color:' + rc + ';">' + p.retention_rate + '%</strong>';
                    html += '<div class="churn-bar"><div class="churn-bar-fill" style="width:' + Math.min(p.retention_rate, 100) + '%; background:' + rc + ';"></div></div>';
                    html += '</td>';
                    html += '</tr>';
                }
                tbody.innerHTML = html;
                document.getElementById('churn-table-wrapper').style.display = 'block';

                jQuery('#churn-table').DataTable({
                    order: [[5, 'desc']],
                    paging: false,
                    autoWidth: false
                });
            } else {
                document.getElementById('churn-loading').style.display = 'none';
                document.getElementById('churn-empty').style.display = 'block';
                if (response.error) {
                    showNotification(response.error, 'error');
                }
            }
        },
        error: function() {
            document.getElementById('churn-loading').style.display = 'none';
            document.getElementById('churn-empty').style.display = 'block';
            showNotification('Failed to load churn data', 'error');
        }
    });

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }
});
</script>
{/literal}