<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-shopping-cart"></i> {$meta.lang['Orders Overview']}</h1>
        <p class="text-muted">{$meta.lang['Orders Overview Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:10px;">
    <div class="col-md-12">
        <div class="btn-group" id="range-buttons">
            <button type="button" class="btn btn-default" data-range="this_month">{$meta.lang['This Month']}</button>
            <button type="button" class="btn btn-default" data-range="this_year">{$meta.lang['This Year']}</button>
            <button type="button" class="btn btn-default" data-range="last_30_days">{$meta.lang['Last 30 Days']}</button>
            <button type="button" class="btn btn-default active" data-range="last_12_months">{$meta.lang['Last 12 Months']}</button>
            <button type="button" class="btn btn-default" data-range="last_2_years">{$meta.lang['Last 2 Years']}</button>
            <button type="button" class="btn btn-default" data-range="all_time">{$meta.lang['All Time']}</button>
        </div>
    </div>
</div>

<div id="summary-container" style="margin-top:15px;">
    <div class="row">
        <div class="col-md-12 text-center" id="summary-loading" style="padding:30px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
        </div>
    </div>
    <div id="summary-cards"></div>
</div>

<div id="charts-container" style="margin-top:5px;">
    <div class="row">
        <div class="col-md-12 text-center" id="chart-loading" style="padding:30px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
        </div>
    </div>
    <div id="charts-panels"></div>
</div>

<style>
    .chart-bar-row {
        display: flex;
        align-items: flex-end;
        height: 160px;
        padding: 0 5px;
        gap: 3px;
    }
    .chart-bar-col {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 28px;
    }
    .chart-bar {
        width: 100%;
        max-width: 50px;
        background: #337ab7;
        border-radius: 3px 3px 0 0;
        min-height: 2px;
        transition: height 0.3s;
        cursor: default;
    }
    .chart-bar:hover {
        opacity: 0.8;
    }
    .chart-label {
        font-size: 10px;
        color: #999;
        margin-top: 6px;
        text-align: center;
    }
    .chart-value {
        font-size: 10px;
        font-weight: bold;
        color: #555;
        margin-bottom: 3px;
    }
    .summary-card-amount {
        font-size: 26px;
        font-weight: bold;
        color: #5cb85c;
    }
    .summary-card-count {
        font-size: 14px;
        color: #777;
    }
    #range-buttons .btn.active {
        background-color: #337ab7;
        color: #fff;
        border-color: #2e6da4;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var baseUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getOrdersOverview';
    var currentRange = 'last_12_months';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    // Range buttons
    jQuery('#range-buttons .btn').on('click', function() {
        jQuery('#range-buttons .btn').removeClass('active');
        jQuery(this).addClass('active');
        currentRange = jQuery(this).data('range');
        loadData(currentRange);
    });

    function showLoading() {
        document.getElementById('summary-loading').style.display = 'block';
        document.getElementById('summary-cards').innerHTML = '';
        document.getElementById('chart-loading').style.display = 'block';
        document.getElementById('charts-panels').innerHTML = '';
    }

    function loadData(range) {
        showLoading();

        jQuery.ajax({
            url: baseUrl + '&range=' + range,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('summary-loading').style.display = 'none';
                document.getElementById('chart-loading').style.display = 'none';

                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }

                renderSummary(response.data.summary);
                renderCharts(response.data.monthly);
            },
            error: function() {
                document.getElementById('summary-loading').style.display = 'none';
                document.getElementById('chart-loading').style.display = 'none';
                showNotification('Failed to load orders data', 'error');
            }
        });
    }

    function renderSummary(summary) {
        var container = document.getElementById('summary-cards');
        if (!summary || summary.length === 0) {
            container.innerHTML = '<div class="row"><div class="col-md-12"><div class="alert alert-info"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No orders found']}{literal}</div></div></div>';
            return;
        }

        var html = '';
        for (var i = 0; i < summary.length; i++) {
            var s = summary[i];
            html += '<div class="row">';

            // Total orders + amount
            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#337ab7;">' + s.total + '</div>';
            html += '<div class="summary-card-count">' + formatMoney(s.currency_prefix, s.total_amount, s.currency_suffix) + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-shopping-cart"></i> {/literal}{$meta.lang['Total Orders']}{literal}</div>';
            html += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(s.currency_code) + '</div>';
            html += '</div></div></div>';

            // Active
            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#5cb85c;">' + s.active + '</div>';
            html += '<div class="summary-card-count">' + formatMoney(s.currency_prefix, s.active_amount, s.currency_suffix) + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-check-circle"></i> {/literal}{$meta.lang['Active']}{literal}</div>';
            html += '</div></div></div>';

            // Pending
            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #f0ad4e;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#f0ad4e;">' + s.pending + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-clock"></i> {/literal}{$meta.lang['Pending']}{literal}</div>';
            html += '</div></div></div>';

            // Cancelled/Fraud
            html += '<div class="col-lg-3 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #d9534f;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#d9534f;">' + s.cancelled + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-ban"></i> {/literal}{$meta.lang['Cancelled']}{literal} / {/literal}{$meta.lang['Fraud']}{literal}</div>';
            html += '</div></div></div>';

            html += '</div>';
        }
        container.innerHTML = html;
    }

    function renderCharts(monthly) {
        var container = document.getElementById('charts-panels');
        if (!monthly || monthly.length === 0) return;

        var html = '';
        for (var c = 0; c < monthly.length; c++) {
            var cur = monthly[c];
            var months = cur.months;
            if (months.length === 0) continue;

            var maxCount = 0;
            var maxAmount = 0;
            for (var m = 0; m < months.length; m++) {
                if (months[m].count > maxCount) maxCount = months[m].count;
                if (months[m].amount > maxAmount) maxAmount = months[m].amount;
            }
            if (maxCount === 0) maxCount = 1;
            if (maxAmount === 0) maxAmount = 1;

            // Orders count chart
            html += '<div class="row"><div class="col-md-6">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['Orders per Month']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            html += '<div class="panel-body" style="overflow-x:auto;">';
            html += '<div class="chart-bar-row">';
            for (var m = 0; m < months.length; m++) {
                var h = Math.max((months[m].count / maxCount) * 150, 2);
                var label = months[m].month.substring(2);
                html += '<div class="chart-bar-col">';
                html += '<div class="chart-value">' + months[m].count + '</div>';
                html += '<div class="chart-bar" style="height:' + h + 'px; background:#337ab7;" title="' + months[m].month + ': ' + months[m].count + ' {/literal}{$meta.lang['orders']}{literal}"></div>';
                html += '<div class="chart-label">' + label + '</div>';
                html += '</div>';
            }
            html += '</div></div></div>';
            html += '</div>';

            // Amount chart
            html += '<div class="col-md-6">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-dollar-sign"></i> {/literal}{$meta.lang['Revenue per Month']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            html += '<div class="panel-body" style="overflow-x:auto;">';
            html += '<div class="chart-bar-row">';
            for (var m = 0; m < months.length; m++) {
                var h2 = Math.max((months[m].amount / maxAmount) * 150, 2);
                var label2 = months[m].month.substring(2);
                html += '<div class="chart-bar-col">';
                html += '<div class="chart-value">' + formatMoney(cur.currency_prefix, months[m].amount, cur.currency_suffix) + '</div>';
                html += '<div class="chart-bar" style="height:' + h2 + 'px; background:#5cb85c;" title="' + months[m].month + ': ' + formatMoney(cur.currency_prefix, months[m].amount, cur.currency_suffix) + '"></div>';
                html += '<div class="chart-label">' + label2 + '</div>';
                html += '</div>';
            }
            html += '</div></div></div>';
            html += '</div></div>';
        }
        container.innerHTML = html;
    }

    // Initial load
    loadData(currentRange);
});
</script>
{/literal}