<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-tachometer-alt"></i> {$meta.lang['Dashboard']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="dash-counts"></div>
    <div id="dash-row2"></div>
    <div id="dash-charts"></div>
    <div id="dash-row3"></div>
</div>

<style>
    .dash-stat {
        text-align: center;
        padding: 18px 10px;
    }
    .dash-stat-value {
        font-size: 32px;
        font-weight: bold;
        line-height: 1.1;
    }
    .dash-stat-label {
        margin-top: 6px;
        color: #888;
        font-size: 13px;
    }
    .dash-stat-sub {
        font-size: 11px;
        color: #aaa;
        margin-top: 2px;
    }
    .hbar-row {
        display: flex;
        align-items: center;
        margin-bottom: 8px;
    }
    .hbar-label {
        width: 160px;
        min-width: 160px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .hbar-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 22px;
        overflow: hidden;
    }
    .hbar-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .hbar-value {
        width: 60px;
        min-width: 60px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    .chart-bar-row {
        display: flex;
        align-items: flex-end;
        height: 130px;
        padding: 0 5px;
        gap: 3px;
    }
    .chart-bar-col {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 20px;
    }
    .chart-bar {
        width: 100%;
        max-width: 40px;
        border-radius: 3px 3px 0 0;
        min-height: 2px;
        transition: height 0.3s;
        cursor: default;
    }
    .chart-bar:hover { opacity: 0.8; }
    .chart-label {
        font-size: 9px;
        color: #999;
        margin-top: 4px;
        text-align: center;
    }
    .chart-value {
        font-size: 9px;
        font-weight: bold;
        color: #555;
        margin-bottom: 2px;
    }
    .donut-wrap {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 20px;
    }
    .donut-legend {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }
    .donut-legend-item {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 12px;
    }
    .donut-legend-color {
        width: 12px;
        height: 12px;
        border-radius: 2px;
        flex-shrink: 0;
    }
    .donut-legend-value {
        font-weight: bold;
        margin-left: auto;
        padding-left: 10px;
    }
    .rev-card {
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 12px;
        border-bottom: 1px solid #eee;
    }
    .rev-card:last-child {
        border-bottom: none;
    }
    .rev-card-amount {
        font-size: 22px;
        font-weight: bold;
        color: #5cb85c;
    }
    .rev-card-sub {
        font-size: 13px;
        color: #999;
    }
    .rev-card-cur {
        font-size: 11px;
        color: #aaa;
        margin-top: 2px;
    }
    .order-card {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid #eee;
    }
    .order-card:last-child {
        border-bottom: none;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getDashboard';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';

            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }

            var d = response.data;
            renderCounts(d.counts, d.statuses, d.churn_rate, d.retention_rate);
            renderRow2(d.statuses, d.revenue, d.recent_orders);
            renderCharts(d.monthly_new);
            renderRow3(d.top_products, d.top_groups);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load dashboard data', 'error');
        }
    });

    function renderCounts(counts, statuses, churnRate, retentionRate) {
        var cards = [
            { value: counts.products, label: '{/literal}{$meta.lang['Total Products']}{literal}', icon: 'fa-cubes', color: '#337ab7' },
            { value: counts.groups, label: '{/literal}{$meta.lang['Total Groups']}{literal}', icon: 'fa-layer-group', color: '#5bc0de' },
            { value: counts.clients, label: '{/literal}{$meta.lang['Total Clients']}{literal}', icon: 'fa-users', color: '#9b59b6' },
            { value: statuses.Active, label: '{/literal}{$meta.lang['Active Services']}{literal}', icon: 'fa-check-circle', color: '#5cb85c' },
            { value: counts.services, label: '{/literal}{$meta.lang['Total Services']}{literal}', icon: 'fa-server', color: '#777' },
            { value: retentionRate + '%', label: '{/literal}{$meta.lang['Retention Rate']}{literal}', icon: 'fa-shield-alt', color: retentionRate >= 70 ? '#5cb85c' : retentionRate >= 40 ? '#f0ad4e' : '#d9534f' },
        ];

        var html = '<div class="row" style="margin-top:10px;">';
        for (var i = 0; i < cards.length; i++) {
            var c = cards[i];
            html += '<div class="col-lg-2 col-md-4 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid ' + c.color + ';">';
            html += '<div class="dash-stat">';
            html += '<div class="dash-stat-value" style="color:' + c.color + ';">' + c.value + '</div>';
            html += '<div class="dash-stat-label"><i class="fa ' + c.icon + '"></i> ' + c.label + '</div>';
            html += '</div></div></div>';
        }
        html += '</div>';
        document.getElementById('dash-counts').innerHTML = html;
    }

    function renderRow2(statuses, revenue, recentOrders) {
        var html = '<div class="row" style="margin-top:5px;">';

        // Donut: Services by Status
        var statusData = [
            { label: '{/literal}{$meta.lang['Active']}{literal}', value: statuses.Active, color: '#5cb85c' },
            { label: '{/literal}{$meta.lang['Suspended']}{literal}', value: statuses.Suspended, color: '#f0ad4e' },
            { label: '{/literal}{$meta.lang['Terminated']}{literal}', value: statuses.Terminated, color: '#d9534f' },
            { label: '{/literal}{$meta.lang['Cancelled']}{literal}', value: statuses.Cancelled, color: '#999' },
            { label: '{/literal}{$meta.lang['Pending']}{literal}', value: statuses.Pending, color: '#5bc0de' },
        ];

        var total = 0;
        for (var i = 0; i < statusData.length; i++) total += statusData[i].value;

        html += '<div class="col-md-4">';
        html += '<div class="panel panel-default" style="min-height:260px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-pie"></i> {/literal}{$meta.lang['Services by Status']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (total > 0) {
            // SVG donut
            var cx = 80, cy = 80, r = 65, ir = 42;
            var angle = -90;
            var svgPaths = '';
            for (var i = 0; i < statusData.length; i++) {
                var sd = statusData[i];
                if (sd.value === 0) continue;
                var sweep = (sd.value / total) * 360;
                var startAngle = angle;
                var endAngle = angle + sweep;
                var largeArc = sweep > 180 ? 1 : 0;
                var startRad = (Math.PI / 180) * startAngle;
                var endRad = (Math.PI / 180) * endAngle;
                var x1o = cx + r * Math.cos(startRad), y1o = cy + r * Math.sin(startRad);
                var x2o = cx + r * Math.cos(endRad), y2o = cy + r * Math.sin(endRad);
                var x1i = cx + ir * Math.cos(endRad), y1i = cy + ir * Math.sin(endRad);
                var x2i = cx + ir * Math.cos(startRad), y2i = cy + ir * Math.sin(startRad);
                svgPaths += '<path d="M' + x1o + ',' + y1o + ' A' + r + ',' + r + ' 0 ' + largeArc + ',1 ' + x2o + ',' + y2o + ' L' + x1i + ',' + y1i + ' A' + ir + ',' + ir + ' 0 ' + largeArc + ',0 ' + x2i + ',' + y2i + ' Z" fill="' + sd.color + '" stroke="#fff" stroke-width="1"><title>' + sd.label + ': ' + sd.value + '</title></path>';
                angle = endAngle;
            }
            var svgCenter = '<text x="' + cx + '" y="' + (cy - 3) + '" text-anchor="middle" font-size="18" font-weight="bold" fill="#333">' + total + '</text>';
            svgCenter += '<text x="' + cx + '" y="' + (cy + 12) + '" text-anchor="middle" font-size="9" fill="#999">{/literal}{$meta.lang['Total']}{literal}</text>';

            html += '<div class="donut-wrap">';
            html += '<svg width="160" height="160" viewBox="0 0 160 160">' + svgPaths + svgCenter + '</svg>';
            html += '<div class="donut-legend">';
            for (var i = 0; i < statusData.length; i++) {
                var sd = statusData[i];
                if (sd.value === 0) continue;
                var pct = total > 0 ? Math.round((sd.value / total) * 100) : 0;
                html += '<div class="donut-legend-item">';
                html += '<div class="donut-legend-color" style="background:' + sd.color + ';"></div>';
                html += '<span>' + sd.label + '</span>';
                html += '<span class="donut-legend-value">' + sd.value + ' <span style="color:#aaa; font-weight:normal;">(' + pct + '%)</span></span>';
                html += '</div>';
            }
            html += '</div></div>';
        } else {
            html += '<p class="text-muted text-center" style="padding:40px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';

        // Revenue panel
        html += '<div class="col-md-4">';
        html += '<div class="panel panel-default" style="min-height:260px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-coins"></i> {/literal}{$meta.lang['Recurring Revenue']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (revenue.length > 0) {
            for (var i = 0; i < revenue.length; i++) {
                var rv = revenue[i];
                html += '<div class="rev-card">';
                html += '<div class="rev-card-amount">' + formatMoney(rv.currency_prefix, rv.annual, rv.currency_suffix) + '</div>';
                html += '<div class="rev-card-sub">{/literal}{$meta.lang['per year']}{literal}</div>';
                html += '<div style="font-size:15px; color:#777; margin-top:4px;">' + formatMoney(rv.currency_prefix, rv.monthly, rv.currency_suffix) + ' <span style="font-size:12px;">{/literal}{$meta.lang['per month']}{literal}</span></div>';
                html += '<div class="rev-card-cur">' + escapeHtml(rv.currency_code) + '</div>';
                html += '</div>';
            }
        } else {
            html += '<p class="text-muted text-center" style="padding:40px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';

        // Recent Orders
        html += '<div class="col-md-4">';
        html += '<div class="panel panel-default" style="min-height:260px;">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-shopping-cart"></i> {/literal}{$meta.lang['Orders (Last 30 Days)']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (recentOrders.length > 0) {
            for (var i = 0; i < recentOrders.length; i++) {
                var o = recentOrders[i];
                html += '<div class="order-card">';
                html += '<div>';
                html += '<div style="font-size:26px; font-weight:bold; color:#337ab7;">' + o.count + '</div>';
                html += '<div style="font-size:12px; color:#999;">{/literal}{$meta.lang['orders']}{literal}</div>';
                html += '</div>';
                html += '<div style="text-align:right;">';
                html += '<div style="font-size:20px; font-weight:bold; color:#5cb85c;">' + formatMoney(o.currency_prefix, o.amount, o.currency_suffix) + '</div>';
                html += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(o.currency_code) + '</div>';
                html += '</div>';
                html += '</div>';
            }
        } else {
            html += '<p class="text-muted text-center" style="padding:40px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';

        html += '</div>';
        document.getElementById('dash-row2').innerHTML = html;
    }

    function renderCharts(monthlyNew) {
        var html = '<div class="row" style="margin-top:5px;">';

        html += '<div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['New Subscriptions (12 mo)']}{literal}</h3></div>';
        html += '<div class="panel-body" style="overflow-x:auto;">';

        if (monthlyNew.length > 0) {
            var maxNew = 0;
            for (var m = 0; m < monthlyNew.length; m++) {
                if (monthlyNew[m].count > maxNew) maxNew = monthlyNew[m].count;
            }
            if (maxNew === 0) maxNew = 1;

            html += '<div class="chart-bar-row">';
            for (var m = 0; m < monthlyNew.length; m++) {
                var h = Math.max((monthlyNew[m].count / maxNew) * 120, 2);
                var label = monthlyNew[m].month.substring(2);
                html += '<div class="chart-bar-col">';
                html += '<div class="chart-value">' + monthlyNew[m].count + '</div>';
                html += '<div class="chart-bar" style="height:' + h + 'px; background:#337ab7;" title="' + monthlyNew[m].month + ': ' + monthlyNew[m].count + '"></div>';
                html += '<div class="chart-label">' + label + '</div>';
                html += '</div>';
            }
            html += '</div>';
        } else {
            html += '<p class="text-muted text-center" style="padding:30px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';
        html += '</div>';
        document.getElementById('dash-charts').innerHTML = html;
    }

    function renderRow3(topProducts, topGroups) {
        var colors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f'];
        var html = '<div class="row" style="margin-top:5px;">';

        // Top Products
        html += '<div class="col-md-6">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-trophy"></i> {/literal}{$meta.lang['Top Products by Active Services']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (topProducts.length > 0) {
            var maxProd = topProducts[0].active;
            if (maxProd === 0) maxProd = 1;
            for (var i = 0; i < topProducts.length; i++) {
                var p = topProducts[i];
                var pct = (p.active / maxProd) * 100;
                html += '<div class="hbar-row">';
                html += '<div class="hbar-label" title="' + escapeHtml(p.name) + '">' + escapeHtml(p.name) + '</div>';
                html += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pct + '%; background:' + colors[i % colors.length] + ';"></div></div>';
                html += '<div class="hbar-value">' + p.active + '</div>';
                html += '</div>';
            }
        } else {
            html += '<p class="text-muted text-center">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';

        // Top Groups
        html += '<div class="col-md-6">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-layer-group"></i> {/literal}{$meta.lang['Top Groups by Services']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (topGroups.length > 0) {
            var maxGrp = topGroups[0].total;
            if (maxGrp === 0) maxGrp = 1;
            for (var i = 0; i < topGroups.length; i++) {
                var g = topGroups[i];
                var pct = (g.total / maxGrp) * 100;
                var activePct = g.total > 0 ? Math.round((g.active / g.total) * 100) : 0;
                html += '<div class="hbar-row">';
                html += '<div class="hbar-label" title="' + escapeHtml(g.name) + '">' + escapeHtml(g.name) + '</div>';
                html += '<div class="hbar-track" style="position:relative;">';
                html += '<div class="hbar-fill" style="width:' + pct + '%; background:' + colors[i % colors.length] + ';"></div>';
                html += '</div>';
                html += '<div class="hbar-value">' + g.total + ' <span style="font-size:10px; color:#5cb85c; font-weight:normal;">(' + g.active + ')</span></div>';
                html += '</div>';
            }
        } else {
            html += '<p class="text-muted text-center">{/literal}{$meta.lang['No data']}{literal}</p>';
        }

        html += '</div></div></div>';

        html += '</div>';
        document.getElementById('dash-row3').innerHTML = html;
    }
});
</script>
{/literal}