<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-users"></i> {$meta.lang['Clients Overview']}</h1>
        <p class="text-muted">{$meta.lang['Clients Overview Description']}</p>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="chart-section"></div>
    <div id="bar-chart"></div>
</div>

<style>
    .donut-wrap {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 20px;
    }
    .donut-legend {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }
    .donut-legend-item {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 12px;
    }
    .donut-legend-color {
        width: 12px;
        height: 12px;
        border-radius: 2px;
        flex-shrink: 0;
    }
    .donut-legend-value {
        font-weight: bold;
        margin-left: auto;
        padding-left: 10px;
    }
    .bucket-row {
        display: flex;
        align-items: center;
        margin-bottom: 8px;
    }
    .bucket-label {
        width: 100px;
        min-width: 100px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
    }
    .bucket-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 24px;
        overflow: hidden;
    }
    .bucket-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .bucket-value {
        width: 80px;
        min-width: 80px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    .chart-bar-row {
        display: flex;
        align-items: flex-end;
        height: 140px;
        padding: 0 5px;
        gap: 3px;
    }
    .chart-bar-col {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 20px;
    }
    .chart-bar {
        width: 100%;
        max-width: 40px;
        border-radius: 3px 3px 0 0;
        min-height: 2px;
        transition: height 0.3s;
        cursor: default;
    }
    .chart-bar:hover { opacity: 0.8; }
    .chart-label {
        font-size: 9px;
        color: #999;
        margin-top: 4px;
        text-align: center;
    }
    .chart-value {
        font-size: 10px;
        font-weight: bold;
        color: #555;
        margin-bottom: 2px;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getClientsOverview';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }
            var d = response.data;
            renderSummary(d);
            renderCharts(d.statuses, d.age_buckets);
            renderBarChart(d.monthly_new);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load data', 'error');
        }
    });

    function renderSummary(d) {
        var nonPaying = d.total_clients - d.paying_clients;
        var html = '<div class="row" style="margin-top:10px;">';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#337ab7;">' + d.total_clients + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-users"></i> {/literal}{$meta.lang['Total Clients']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#5cb85c;">' + d.paying_clients + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-credit-card"></i> {/literal}{$meta.lang['Paying Clients']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #f0ad4e;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#f0ad4e;">' + nonPaying + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-user-slash"></i> {/literal}{$meta.lang['Non-Paying']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #9b59b6;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#9b59b6;">' + d.avg_lifetime_months + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-clock"></i> {/literal}{$meta.lang['Avg Lifetime']}{literal} ({/literal}{$meta.lang['months']}{literal})</div>';
        html += '</div></div></div>';

        html += '</div>';
        document.getElementById('summary-cards').innerHTML = html;
    }

    function renderCharts(statuses, ageBuckets) {
        var html = '<div class="row" style="margin-top:5px;">';

        // Status donut
        var statusColors = {
            'Active': '#5cb85c',
            'Inactive': '#f0ad4e',
            'Closed': '#d9534f'
        };
        var statusEntries = [];
        var total = 0;
        for (var key in statuses) {
            statusEntries.push({ label: key, value: statuses[key], color: statusColors[key] || '#999' });
            total += statuses[key];
        }

        html += '<div class="col-md-5">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-pie"></i> {/literal}{$meta.lang['Clients by Status']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (total > 0) {
            var cx = 80, cy = 80, r = 65, ir = 42;
            var angle = -90;
            var svgPaths = '';
            for (var i = 0; i < statusEntries.length; i++) {
                var sd = statusEntries[i];
                if (sd.value === 0) continue;
                var sweep = (sd.value / total) * 360;
                var largeArc = sweep > 180 ? 1 : 0;
                var startRad = (Math.PI / 180) * angle;
                var endRad = (Math.PI / 180) * (angle + sweep);
                var x1o = cx + r * Math.cos(startRad), y1o = cy + r * Math.sin(startRad);
                var x2o = cx + r * Math.cos(endRad), y2o = cy + r * Math.sin(endRad);
                var x1i = cx + ir * Math.cos(endRad), y1i = cy + ir * Math.sin(endRad);
                var x2i = cx + ir * Math.cos(startRad), y2i = cy + ir * Math.sin(startRad);
                svgPaths += '<path d="M' + x1o + ',' + y1o + ' A' + r + ',' + r + ' 0 ' + largeArc + ',1 ' + x2o + ',' + y2o + ' L' + x1i + ',' + y1i + ' A' + ir + ',' + ir + ' 0 ' + largeArc + ',0 ' + x2i + ',' + y2i + ' Z" fill="' + sd.color + '" stroke="#fff" stroke-width="1"><title>' + sd.label + ': ' + sd.value + '</title></path>';
                angle += sweep;
            }
            var svgCenter = '<text x="' + cx + '" y="' + (cy - 3) + '" text-anchor="middle" font-size="18" font-weight="bold" fill="#333">' + total + '</text>';
            svgCenter += '<text x="' + cx + '" y="' + (cy + 12) + '" text-anchor="middle" font-size="9" fill="#999">{/literal}{$meta.lang['Total']}{literal}</text>';

            html += '<div class="donut-wrap">';
            html += '<svg width="160" height="160" viewBox="0 0 160 160">' + svgPaths + svgCenter + '</svg>';
            html += '<div class="donut-legend">';
            for (var i = 0; i < statusEntries.length; i++) {
                var sd = statusEntries[i];
                if (sd.value === 0) continue;
                var pct = Math.round((sd.value / total) * 100);
                html += '<div class="donut-legend-item">';
                html += '<div class="donut-legend-color" style="background:' + sd.color + ';"></div>';
                html += '<span>' + sd.label + '</span>';
                html += '<span class="donut-legend-value">' + sd.value + ' (' + pct + '%)</span>';
                html += '</div>';
            }
            html += '</div></div>';
        }
        html += '</div></div></div>';

        // Age distribution bars
        html += '<div class="col-md-7">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-hourglass-half"></i> {/literal}{$meta.lang['Client Age Distribution']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        var maxBucket = 0;
        for (var b = 0; b < ageBuckets.length; b++) {
            if (ageBuckets[b].count > maxBucket) maxBucket = ageBuckets[b].count;
        }
        if (maxBucket === 0) maxBucket = 1;

        var bucketColors = ['#5bc0de', '#337ab7', '#5cb85c', '#8bc34a', '#f0ad4e', '#e67e22', '#d9534f'];
        for (var b = 0; b < ageBuckets.length; b++) {
            var bk = ageBuckets[b];
            var pct = (bk.count / maxBucket) * 100;
            html += '<div class="bucket-row">';
            html += '<div class="bucket-label">' + bk.label + '</div>';
            html += '<div class="bucket-track"><div class="bucket-fill" style="width:' + pct + '%; background:' + bucketColors[b % bucketColors.length] + ';"></div></div>';
            html += '<div class="bucket-value">' + bk.count + ' {/literal}{$meta.lang['clients']}{literal}</div>';
            html += '</div>';
        }

        html += '</div></div></div>';
        html += '</div>';
        document.getElementById('chart-section').innerHTML = html;
    }

    function renderBarChart(monthlyNew) {
        if (!monthlyNew || monthlyNew.length === 0) return;

        var maxNew = 0;
        for (var m = 0; m < monthlyNew.length; m++) {
            if (monthlyNew[m].count > maxNew) maxNew = monthlyNew[m].count;
        }
        if (maxNew === 0) maxNew = 1;

        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['New Clients per Month']}{literal}</h3></div>';
        html += '<div class="panel-body" style="overflow-x:auto;">';
        html += '<div class="chart-bar-row">';

        for (var m = 0; m < monthlyNew.length; m++) {
            var h = Math.max((monthlyNew[m].count / maxNew) * 130, 2);
            var label = monthlyNew[m].month.substring(2);
            html += '<div class="chart-bar-col">';
            html += '<div class="chart-value">' + monthlyNew[m].count + '</div>';
            html += '<div class="chart-bar" style="height:' + h + 'px; background:#337ab7;" title="' + monthlyNew[m].month + ': ' + monthlyNew[m].count + '"></div>';
            html += '<div class="chart-label">' + label + '</div>';
            html += '</div>';
        }

        html += '</div></div></div></div></div>';
        document.getElementById('bar-chart').innerHTML = html;
    }
});
</script>
{/literal}