<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-gem"></i> {$meta.lang['Client Lifetime Value']}</h1>
        <p class="text-muted">{$meta.lang['Client LTV Description']}</p>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="chart-section"></div>
</div>

<style>
    .bucket-row {
        display: flex;
        align-items: center;
        margin-bottom: 8px;
    }
    .bucket-label {
        width: 100px;
        min-width: 100px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
    }
    .bucket-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 26px;
        overflow: hidden;
    }
    .bucket-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .bucket-value {
        width: 80px;
        min-width: 80px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    .hbar-row {
        display: flex;
        align-items: center;
        margin-bottom: 6px;
    }
    .hbar-label {
        width: 200px;
        min-width: 200px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .hbar-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 22px;
        overflow: hidden;
    }
    .hbar-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .hbar-value {
        width: 100px;
        min-width: 100px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getClientLTV';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data || response.data.length === 0) {
                if (response.error) showNotification(response.error, 'error');
                document.getElementById('summary-cards').innerHTML =
                    '<div class="row"><div class="col-md-12"><div class="alert alert-info" style="margin-top:15px;"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No clients found']}{literal}</div></div></div>';
                return;
            }
            renderAll(response.data);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load data', 'error');
        }
    });

    function renderAll(data) {
        var summaryHtml = '';
        var chartHtml = '';

        for (var ci = 0; ci < data.length; ci++) {
            var cur = data[ci];
            var s = cur.summary;
            var buckets = cur.buckets;
            var topClients = cur.top_clients;

            // Summary cards
            summaryHtml += '<div class="row" style="margin-top:10px;">';

            summaryHtml += '<div class="col-lg-2 col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:24px; font-weight:bold; color:#337ab7;">' + formatMoney(cur.currency_prefix, s.avg_ltv, cur.currency_suffix) + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-gem"></i> {/literal}{$meta.lang['Average LTV']}{literal}</div>';
            summaryHtml += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(cur.currency_code) + '</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-lg-2 col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:24px; font-weight:bold; color:#5cb85c;">' + formatMoney(cur.currency_prefix, s.total_revenue, cur.currency_suffix) + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-coins"></i> {/literal}{$meta.lang['Total Revenue']}{literal}</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-lg-2 col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #f0ad4e;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:24px; font-weight:bold; color:#f0ad4e;">' + formatMoney(cur.currency_prefix, s.avg_monthly_value, cur.currency_suffix) + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-calendar-alt"></i> {/literal}{$meta.lang['Avg Monthly Value']}{literal}</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-lg-2 col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #5bc0de;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:28px; font-weight:bold; color:#5bc0de;">' + s.paying_clients + ' <span style="font-size:14px; color:#aaa;">/ ' + s.total_clients + '</span></div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-users"></i> {/literal}{$meta.lang['Paying Clients']}{literal}</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-lg-2 col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #9b59b6;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:28px; font-weight:bold; color:#9b59b6;">' + s.avg_lifetime_months + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-clock"></i> {/literal}{$meta.lang['Avg Lifetime']}{literal} ({/literal}{$meta.lang['months']}{literal})</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '</div>';

            // Charts row
            chartHtml += '<div class="row" style="margin-top:5px;">';

            // Revenue distribution buckets
            chartHtml += '<div class="col-md-6">';
            chartHtml += '<div class="panel panel-default">';
            chartHtml += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['Revenue Distribution']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            chartHtml += '<div class="panel-body">';

            var maxBucket = 0;
            for (var b = 0; b < buckets.length; b++) {
                if (buckets[b].count > maxBucket) maxBucket = buckets[b].count;
            }
            if (maxBucket === 0) maxBucket = 1;

            var bucketColors = ['#eee', '#5bc0de', '#337ab7', '#5cb85c', '#f0ad4e', '#e67e22', '#d9534f'];
            for (var b = 0; b < buckets.length; b++) {
                var bk = buckets[b];
                var pct = (bk.count / maxBucket) * 100;
                chartHtml += '<div class="bucket-row">';
                chartHtml += '<div class="bucket-label">' + bk.label + '</div>';
                chartHtml += '<div class="bucket-track"><div class="bucket-fill" style="width:' + pct + '%; background:' + bucketColors[b % bucketColors.length] + ';"></div></div>';
                chartHtml += '<div class="bucket-value">' + bk.count + ' {/literal}{$meta.lang['clients']}{literal}</div>';
                chartHtml += '</div>';
            }

            chartHtml += '</div></div></div>';

            // Top clients by revenue
            chartHtml += '<div class="col-md-6">';
            chartHtml += '<div class="panel panel-default">';
            chartHtml += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-trophy"></i> {/literal}{$meta.lang['Top Clients by Revenue']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            chartHtml += '<div class="panel-body">';

            if (topClients.length > 0) {
                var maxRev = topClients[0].revenue;
                if (maxRev === 0) maxRev = 1;
                var barColors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f', '#9b59b6', '#1abc9c', '#e67e22', '#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#8e44ad', '#16a085', '#c0392b'];

                for (var j = 0; j < topClients.length; j++) {
                    var cl = topClients[j];
                    if (cl.revenue === 0) continue;
                    var pctBar = (cl.revenue / maxRev) * 100;
                    chartHtml += '<div class="hbar-row">';
                    chartHtml += '<div class="hbar-label" title="' + escapeHtml(cl.name) + '">' + escapeHtml(cl.name) + '</div>';
                    chartHtml += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pctBar + '%; background:' + barColors[j % barColors.length] + ';"></div></div>';
                    chartHtml += '<div class="hbar-value">' + formatMoney(cur.currency_prefix, cl.revenue, cur.currency_suffix) + '</div>';
                    chartHtml += '</div>';
                }
            }

            chartHtml += '</div></div></div>';
            chartHtml += '</div>';
        }

        document.getElementById('summary-cards').innerHTML = summaryHtml;
        document.getElementById('chart-section').innerHTML = chartHtml;
    }
});
</script>
{/literal}