<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-dollar-sign"></i> {$meta.lang['Revenue by Product']}</h1>
        <p class="text-muted">{$meta.lang['Revenue by Product Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:15px;" id="summary-cards">
    <div class="col-md-12">
        <div class="text-center" id="summary-loading" style="padding:30px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
        </div>
        <div id="summary-container" style="display:none;"></div>
    </div>
</div>

<div class="row" style="margin-top:5px;">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-dollar-sign"></i> {$meta.lang['Revenue by Product']}</h3>
            </div>
            <div class="panel-body">
                <div class="text-center" id="revenue-loading" style="padding:40px 0;">
                    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
                    <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
                </div>
                <div class="table-responsive" id="revenue-table-wrapper" style="display:none;">
                    <table class="table table-striped table-hover" id="revenue-table" style="width:100%; table-layout:fixed;">
                        <thead>
                            <tr>
                                <th style="width:50px;">#</th>
                                <th style="width:25%;">{$meta.lang['Product Name']}</th>
                                <th style="width:15%;">{$meta.lang['Group']}</th>
                                <th style="width:70px;">{$meta.lang['Currency']}</th>
                                <th style="width:70px;">{$meta.lang['Active']}</th>
                                <th style="width:14%;">{$meta.lang['Annual Revenue']}</th>
                                <th style="width:14%;">{$meta.lang['Monthly Revenue']}</th>
                            </tr>
                        </thead>
                        <tbody id="revenue-tbody">
                        </tbody>
                    </table>
                </div>
                <div class="alert alert-info" id="revenue-empty" style="display:none;">
                    <i class="fa fa-info-circle"></i> {$meta.lang['No revenue data']}
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    #revenue-table td,
    #revenue-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
    .revenue-card-annual {
        font-size: 24px;
        font-weight: bold;
        color: #5cb85c;
    }
    .revenue-card-monthly {
        font-size: 18px;
        color: #777;
    }
    .revenue-card-currency {
        font-size: 12px;
        color: #999;
        margin-top: 2px;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getProductsRevenue';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                // Summary cards — one per currency
                var summary = response.data.summary;
                document.getElementById('summary-loading').style.display = 'none';
                var container = document.getElementById('summary-container');

                if (summary.length > 0) {
                    var cardsHtml = '<div class="row">';
                    var colClass = summary.length === 1 ? 'col-md-4 col-md-offset-4' :
                                   summary.length === 2 ? 'col-md-4 col-md-offset-2' :
                                   summary.length === 3 ? 'col-md-4' : 'col-md-3';
                    for (var i = 0; i < summary.length; i++) {
                        var s = summary[i];
                        cardsHtml += '<div class="' + colClass + ' col-sm-6">';
                        cardsHtml += '<div class="panel panel-default" style="border-top: 3px solid #5cb85c;">';
                        cardsHtml += '<div class="panel-body text-center">';
                        cardsHtml += '<div class="revenue-card-annual">' + formatMoney(s.currency_prefix, s.annual, s.currency_suffix) + '</div>';
                        cardsHtml += '<div class="text-muted" style="margin-top:2px;"><i class="fa fa-calendar"></i> {/literal}{$meta.lang['Annual Revenue']}{literal}</div>';
                        cardsHtml += '<hr style="margin:8px 0;">';
                        cardsHtml += '<div class="revenue-card-monthly">' + formatMoney(s.currency_prefix, s.monthly, s.currency_suffix) + '</div>';
                        cardsHtml += '<div class="text-muted" style="margin-top:2px;"><i class="fa fa-calendar-alt"></i> {/literal}{$meta.lang['Monthly Revenue']}{literal}</div>';
                        cardsHtml += '<div class="revenue-card-currency">' + escapeHtml(s.currency_code) + ' &middot; ' + s.active_services + ' {/literal}{$meta.lang['services']}{literal}</div>';
                        cardsHtml += '</div></div></div>';
                    }
                    cardsHtml += '</div>';
                    container.innerHTML = cardsHtml;
                }
                container.style.display = 'block';

                // Table
                var products = response.data.products;
                document.getElementById('revenue-loading').style.display = 'none';

                if (products.length === 0) {
                    document.getElementById('revenue-empty').style.display = 'block';
                    return;
                }

                var tbody = document.getElementById('revenue-tbody');
                var html = '';
                for (var j = 0; j < products.length; j++) {
                    var p = products[j];
                    html += '<tr>';
                    html += '<td>' + p.product_id + '</td>';
                    html += '<td>' + escapeHtml(p.product_name) + '</td>';
                    html += '<td>' + escapeHtml(p.group_name) + '</td>';
                    html += '<td><span class="label label-info">' + escapeHtml(p.currency_code) + '</span></td>';
                    html += '<td data-order="' + p.active_services + '"><span class="label label-success">' + p.active_services + '</span></td>';
                    html += '<td data-order="' + p.annual + '" style="text-align:right; font-weight:bold; color:#5cb85c;">' + formatMoney(p.currency_prefix, p.annual, p.currency_suffix) + '</td>';
                    html += '<td data-order="' + p.monthly + '" style="text-align:right; color:#777;">' + formatMoney(p.currency_prefix, p.monthly, p.currency_suffix) + '</td>';
                    html += '</tr>';
                }
                tbody.innerHTML = html;
                document.getElementById('revenue-table-wrapper').style.display = 'block';

                jQuery('#revenue-table').DataTable({
                    order: [[5, 'desc']],
                    paging: false,
                    autoWidth: false
                });
            } else {
                document.getElementById('summary-loading').style.display = 'none';
                document.getElementById('revenue-loading').style.display = 'none';
                document.getElementById('revenue-empty').style.display = 'block';
                if (response.error) {
                    showNotification(response.error, 'error');
                }
            }
        },
        error: function() {
            document.getElementById('summary-loading').style.display = 'none';
            document.getElementById('revenue-loading').style.display = 'none';
            document.getElementById('revenue-empty').style.display = 'block';
            showNotification('Failed to load revenue data', 'error');
        }
    });

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }
});
</script>
{/literal}