<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-cubes"></i> {$meta.lang['Products Overview']}</h1>
        <p class="text-muted">{$meta.lang['Products Overview Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:15px;">
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #337ab7;">
            <div class="panel-body text-center">
                <div id="stat-total-products" style="font-size:32px; font-weight:bold; color:#337ab7;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-cubes"></i> {$meta.lang['Total Products']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #5bc0de;">
            <div class="panel-body text-center">
                <div id="stat-total-groups" style="font-size:32px; font-weight:bold; color:#5bc0de;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-layer-group"></i> {$meta.lang['Product Groups']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #5cb85c;">
            <div class="panel-body text-center">
                <div id="stat-active-services" style="font-size:32px; font-weight:bold; color:#5cb85c;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-check-circle"></i> {$meta.lang['Active Services']}
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6">
        <div class="panel panel-default" style="border-top: 3px solid #777;">
            <div class="panel-body text-center">
                <div id="stat-total-services" style="font-size:32px; font-weight:bold; color:#777;">
                    <i class="fa fa-spinner fa-spin" style="font-size:24px; color:#999;"></i>
                </div>
                <div class="text-muted" style="margin-top:5px;">
                    <i class="fa fa-server"></i> {$meta.lang['Total Services']}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-cubes"></i> {$meta.lang['Products']}</h3>
            </div>
            <div class="panel-body" id="products-table-container">
                <div class="text-center" id="products-loading" style="padding:40px 0;">
                    <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
                    <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
                </div>
                <div class="table-responsive" id="products-table-wrapper" style="display:none;">
                    <table class="table table-striped table-hover" id="products-table" style="width:100%; table-layout:fixed;">
                        <thead>
                            <tr>
                                <th style="width:50px;">#</th>
                                <th style="width:30%;">{$meta.lang['Product Name']}</th>
                                <th style="width:90px;">{$meta.lang['Type']}</th>
                                <th style="width:20%;">{$meta.lang['Group']}</th>
                                <th style="width:80px;">{$meta.lang['Active']}</th>
                                <th style="width:80px;">{$meta.lang['Suspended']}</th>
                                <th style="width:100px;">{$meta.lang['Terminated']}/{$meta.lang['Cancelled']}</th>
                                <th style="width:70px;">{$meta.lang['Total']}</th>
                            </tr>
                        </thead>
                        <tbody id="products-tbody">
                        </tbody>
                    </table>
                </div>
                <div class="alert alert-info" id="products-empty" style="display:none;">
                    <i class="fa fa-info-circle"></i> {$meta.lang['No products found']}
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    #products-table td,
    #products-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getProductsOverview';

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                var s = response.data.summary;
                document.getElementById('stat-total-products').textContent = s.total_products;
                document.getElementById('stat-total-groups').textContent = s.total_groups;
                document.getElementById('stat-active-services').textContent = s.active_services;
                document.getElementById('stat-total-services').textContent = s.total_services;

                var products = response.data.products;
                document.getElementById('products-loading').style.display = 'none';

                if (products.length === 0) {
                    document.getElementById('products-empty').style.display = 'block';
                    return;
                }

                var tbody = document.getElementById('products-tbody');
                var html = '';
                for (var i = 0; i < products.length; i++) {
                    var p = products[i];
                    var rowClass = (p.hidden || p.retired) ? ' class="text-muted"' : '';
                    var badges = '';
                    if (p.hidden) {
                        badges += ' <span class="label label-default">{/literal}{$meta.lang['Hidden']}{literal}</span>';
                    }
                    if (p.retired) {
                        badges += ' <span class="label label-default">{/literal}{$meta.lang['Retired']}{literal}</span>';
                    }
                    var endedCount = p.terminated + p.cancelled;

                    html += '<tr' + rowClass + '>';
                    html += '<td>' + p.id + '</td>';
                    html += '<td>' + escapeHtml(p.name) + badges + '</td>';
                    html += '<td>' + escapeHtml(p.type) + '</td>';
                    html += '<td>' + escapeHtml(p.group_name) + '</td>';
                    html += '<td data-order="' + p.active + '"><span class="label label-success">' + p.active + '</span></td>';
                    html += '<td data-order="' + p.suspended + '"><span class="label label-warning">' + p.suspended + '</span></td>';
                    html += '<td data-order="' + endedCount + '"><span class="label label-danger">' + endedCount + '</span></td>';
                    html += '<td data-order="' + p.total + '"><strong>' + p.total + '</strong></td>';
                    html += '</tr>';
                }
                tbody.innerHTML = html;
                document.getElementById('products-table-wrapper').style.display = 'block';

                jQuery('#products-table').DataTable({
                    order: [[4, 'desc']],
                    paging: false,
                    autoWidth: false
                });
            } else {
                document.getElementById('products-loading').style.display = 'none';
                document.getElementById('products-empty').style.display = 'block';
                if (response.error) {
                    showNotification(response.error, 'error');
                }
            }
        },
        error: function() {
            document.getElementById('products-loading').style.display = 'none';
            document.getElementById('products-empty').style.display = 'block';
            showNotification('Failed to load products data', 'error');
        }
    });

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }
});
</script>
{/literal}