<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-box-open"></i> {$meta.lang['Orders by Product']}</h1>
        <p class="text-muted">{$meta.lang['Orders by Product Description']}</p>
    </div>
</div>

<div class="row" style="margin-top:10px;">
    <div class="col-md-12">
        <div class="btn-group" id="range-buttons">
            <button type="button" class="btn btn-default" data-range="this_month">{$meta.lang['This Month']}</button>
            <button type="button" class="btn btn-default" data-range="this_year">{$meta.lang['This Year']}</button>
            <button type="button" class="btn btn-default" data-range="last_30_days">{$meta.lang['Last 30 Days']}</button>
            <button type="button" class="btn btn-default active" data-range="last_12_months">{$meta.lang['Last 12 Months']}</button>
            <button type="button" class="btn btn-default" data-range="last_2_years">{$meta.lang['Last 2 Years']}</button>
            <button type="button" class="btn btn-default" data-range="all_time">{$meta.lang['All Time']}</button>
        </div>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="chart-section"></div>
    <div id="table-section"></div>
</div>

<style>
    #range-buttons .btn.active {
        background-color: #337ab7;
        color: #fff;
        border-color: #2e6da4;
    }
    .hbar-row {
        display: flex;
        align-items: center;
        margin-bottom: 6px;
    }
    .hbar-label {
        width: 200px;
        min-width: 200px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .hbar-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 22px;
        overflow: hidden;
        position: relative;
    }
    .hbar-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
    }
    .hbar-value {
        width: 70px;
        min-width: 70px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    #obp-table td,
    #obp-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var baseUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getOrdersByProduct';
    var currentRange = 'last_12_months';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery('#range-buttons .btn').on('click', function() {
        jQuery('#range-buttons .btn').removeClass('active');
        jQuery(this).addClass('active');
        currentRange = jQuery(this).data('range');
        loadData(currentRange);
    });

    function showLoading() {
        document.getElementById('main-loading').style.display = 'block';
        document.getElementById('summary-cards').innerHTML = '';
        document.getElementById('chart-section').innerHTML = '';
        document.getElementById('table-section').innerHTML = '';
        // Destroy existing DataTable
        if (jQuery.fn.DataTable.isDataTable('#obp-table')) {
            jQuery('#obp-table').DataTable().destroy();
        }
    }

    function loadData(range) {
        showLoading();

        jQuery.ajax({
            url: baseUrl + '&range=' + range,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';

                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }

                var summary = response.data.summary;
                var products = response.data.products;

                if (!summary || summary.length === 0) {
                    document.getElementById('summary-cards').innerHTML =
                        '<div class="row"><div class="col-md-12"><div class="alert alert-info" style="margin-top:15px;"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No orders found']}{literal}</div></div></div>';
                    return;
                }

                renderSummary(summary);
                renderChart(products);
                renderTable(products);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('Failed to load data', 'error');
            }
        });
    }

    function renderSummary(summary) {
        var html = '';
        for (var i = 0; i < summary.length; i++) {
            var s = summary[i];
            html += '<div class="row" style="margin-top:10px;">';

            html += '<div class="col-md-4 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#337ab7;">' + s.total_orders + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-shopping-cart"></i> {/literal}{$meta.lang['Total Orders']}{literal}</div>';
            html += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(s.currency_code) + '</div>';
            html += '</div></div></div>';

            html += '<div class="col-md-4 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#5cb85c;">' + formatMoney(s.currency_prefix, s.total_amount, s.currency_suffix) + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-dollar-sign"></i> {/literal}{$meta.lang['Total Amount']}{literal}</div>';
            html += '</div></div></div>';

            html += '<div class="col-md-4 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid #5bc0de;">';
            html += '<div class="panel-body text-center">';
            html += '<div style="font-size:28px; font-weight:bold; color:#5bc0de;">' + s.products_count + '</div>';
            html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-cubes"></i> {/literal}{$meta.lang['Products Ordered']}{literal}</div>';
            html += '</div></div></div>';

            html += '</div>';
        }
        document.getElementById('summary-cards').innerHTML = html;
    }

    function renderChart(products) {
        if (!products || products.length === 0) return;

        // Group by currency for separate charts
        var byCurrency = {};
        for (var i = 0; i < products.length; i++) {
            var p = products[i];
            if (!byCurrency[p.currency_code]) {
                byCurrency[p.currency_code] = {
                    currency_code: p.currency_code,
                    currency_prefix: p.currency_prefix,
                    currency_suffix: p.currency_suffix,
                    items: []
                };
            }
            byCurrency[p.currency_code].items.push(p);
        }

        var html = '';
        var colors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f', '#9b59b6', '#1abc9c', '#e67e22', '#3498db', '#e74c3c'];

        for (var code in byCurrency) {
            var cur = byCurrency[code];
            var items = cur.items.slice(0, 15); // Top 15
            var maxCount = items.length > 0 ? items[0].order_count : 1;
            if (maxCount === 0) maxCount = 1;

            html += '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
            html += '<div class="panel panel-default">';
            html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['Top Products']}{literal} <span class="label label-info">' + escapeHtml(code) + '</span></h3></div>';
            html += '<div class="panel-body">';

            for (var j = 0; j < items.length; j++) {
                var it = items[j];
                var pct = (it.order_count / maxCount) * 100;
                var color = colors[j % colors.length];
                html += '<div class="hbar-row">';
                html += '<div class="hbar-label" title="' + escapeHtml(it.product_name) + '">' + escapeHtml(it.product_name) + '</div>';
                html += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pct + '%; background:' + color + ';"></div></div>';
                html += '<div class="hbar-value">' + it.order_count + '</div>';
                html += '</div>';
            }

            html += '</div></div></div></div>';
        }

        document.getElementById('chart-section').innerHTML = html;
    }

    function renderTable(products) {
        if (!products || products.length === 0) return;

        var html = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-table"></i> {/literal}{$meta.lang['Orders by Product']}{literal}</h3></div>';
        html += '<div class="panel-body"><div class="table-responsive">';
        html += '<table class="table table-striped table-hover" id="obp-table" style="width:100%; table-layout:fixed;">';
        html += '<thead><tr>';
        html += '<th style="width:30%;">{/literal}{$meta.lang['Product Name']}{literal}</th>';
        html += '<th style="width:20%;">{/literal}{$meta.lang['Group']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Currency']}{literal}</th>';
        html += '<th style="width:80px;">{/literal}{$meta.lang['Orders']}{literal}</th>';
        html += '<th style="width:15%;">{/literal}{$meta.lang['Total Amount']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < products.length; i++) {
            var p = products[i];
            html += '<tr>';
            html += '<td>' + escapeHtml(p.product_name) + '</td>';
            html += '<td>' + escapeHtml(p.group_name) + '</td>';
            html += '<td><span class="label label-info">' + escapeHtml(p.currency_code) + '</span></td>';
            html += '<td data-order="' + p.order_count + '"><strong>' + p.order_count + '</strong></td>';
            html += '<td data-order="' + p.total_amount + '" style="text-align:right;">' + formatMoney(p.currency_prefix, p.total_amount, p.currency_suffix) + '</td>';
            html += '</tr>';
        }

        html += '</tbody></table></div></div></div></div></div>';
        document.getElementById('table-section').innerHTML = html;

        jQuery('#obp-table').DataTable({
            order: [[3, 'desc']],
            paging: false,
            autoWidth: false
        });
    }

    loadData(currentRange);
});
</script>
{/literal}