<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-chart-bar"></i> {$meta.lang['Group Distribution']}</h1>
        <p class="text-muted">{$meta.lang['Group Distribution Description']}</p>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="chart-section"></div>
    <div id="table-section"></div>
</div>

<style>
    .hbar-row {
        display: flex;
        align-items: center;
        margin-bottom: 8px;
    }
    .hbar-label {
        width: 200px;
        min-width: 200px;
        text-align: right;
        padding-right: 10px;
        font-size: 12px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .hbar-track {
        flex: 1;
        background: #f5f5f5;
        border-radius: 3px;
        height: 26px;
        overflow: hidden;
        position: relative;
    }
    .hbar-fill {
        height: 100%;
        border-radius: 3px;
        transition: width 0.4s;
        min-width: 2px;
        position: relative;
    }
    .hbar-fill-label {
        position: absolute;
        right: 6px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 11px;
        font-weight: bold;
        color: #fff;
        text-shadow: 0 1px 1px rgba(0,0,0,0.3);
    }
    .hbar-value {
        width: 90px;
        min-width: 90px;
        text-align: right;
        padding-left: 8px;
        font-size: 12px;
        font-weight: bold;
    }
    .donut-container {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 40px;
        flex-wrap: wrap;
    }
    .donut-svg {
        width: 220px;
        height: 220px;
    }
    .donut-legend {
        display: flex;
        flex-direction: column;
        gap: 6px;
    }
    .donut-legend-item {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 12px;
    }
    .donut-legend-color {
        width: 14px;
        height: 14px;
        border-radius: 3px;
        flex-shrink: 0;
    }
    .donut-legend-label {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    .donut-legend-value {
        font-weight: bold;
        margin-left: auto;
        white-space: nowrap;
    }
    #dist-table td,
    #dist-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getGroupsDistribution';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';

            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }

            var summary = response.data.summary;
            var groups = response.data.groups;

            if (!groups || groups.length === 0) {
                document.getElementById('summary-cards').innerHTML =
                    '<div class="row"><div class="col-md-12"><div class="alert alert-info" style="margin-top:15px;"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No groups found']}{literal}</div></div></div>';
                return;
            }

            renderSummary(summary);
            renderDonutChart(groups);
            renderBarChart(groups);
            renderTable(groups);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load data', 'error');
        }
    });

    function renderSummary(summary) {
        var html = '<div class="row" style="margin-top:10px;">';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #5bc0de;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#5bc0de;">' + summary.total_groups + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-layer-group"></i> {/literal}{$meta.lang['Total Groups']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #777;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#777;">' + summary.total_services + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-server"></i> {/literal}{$meta.lang['Total Services']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#5cb85c;">' + summary.active_services + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-check-circle"></i> {/literal}{$meta.lang['Active Services']}{literal}</div>';
        html += '</div></div></div>';

        html += '<div class="col-md-3 col-sm-6">';
        html += '<div class="panel panel-default" style="border-top:3px solid #f0ad4e;">';
        html += '<div class="panel-body text-center">';
        html += '<div style="font-size:32px; font-weight:bold; color:#f0ad4e;">' + summary.ungrouped + '</div>';
        html += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-unlink"></i> {/literal}{$meta.lang['Ungrouped']}{literal}</div>';
        html += '</div></div></div>';

        html += '</div>';
        document.getElementById('summary-cards').innerHTML = html;
    }

    function renderDonutChart(groups) {
        var colors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f', '#9b59b6', '#1abc9c', '#e67e22', '#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#8e44ad', '#16a085', '#c0392b'];

        // Build donut segments via SVG
        var total = 0;
        for (var i = 0; i < groups.length; i++) total += groups[i].total;
        if (total === 0) return;

        var cx = 110, cy = 110, r = 90, ir = 55;
        var angle = -90; // start at top
        var svgPaths = '';

        for (var i = 0; i < groups.length; i++) {
            var g = groups[i];
            if (g.total === 0) continue;
            var sweep = (g.total / total) * 360;
            var startAngle = angle;
            var endAngle = angle + sweep;
            var largeArc = sweep > 180 ? 1 : 0;

            var startRad = (Math.PI / 180) * startAngle;
            var endRad = (Math.PI / 180) * endAngle;

            var x1o = cx + r * Math.cos(startRad);
            var y1o = cy + r * Math.sin(startRad);
            var x2o = cx + r * Math.cos(endRad);
            var y2o = cy + r * Math.sin(endRad);
            var x1i = cx + ir * Math.cos(endRad);
            var y1i = cy + ir * Math.sin(endRad);
            var x2i = cx + ir * Math.cos(startRad);
            var y2i = cy + ir * Math.sin(startRad);

            var color = colors[i % colors.length];
            svgPaths += '<path d="M' + x1o + ',' + y1o
                + ' A' + r + ',' + r + ' 0 ' + largeArc + ',1 ' + x2o + ',' + y2o
                + ' L' + x1i + ',' + y1i
                + ' A' + ir + ',' + ir + ' 0 ' + largeArc + ',0 ' + x2i + ',' + y2i
                + ' Z" fill="' + color + '" stroke="#fff" stroke-width="1">'
                + '<title>' + escapeHtml(g.name) + ': ' + g.total + ' (' + g.percent + '%)</title></path>';

            angle = endAngle;
        }

        // Center text
        var svgCenter = '<text x="' + cx + '" y="' + (cy - 5) + '" text-anchor="middle" font-size="24" font-weight="bold" fill="#333">' + total + '</text>';
        svgCenter += '<text x="' + cx + '" y="' + (cy + 15) + '" text-anchor="middle" font-size="11" fill="#999">{/literal}{$meta.lang['Total Services']}{literal}</text>';

        var svg = '<svg class="donut-svg" viewBox="0 0 220 220">' + svgPaths + svgCenter + '</svg>';

        // Legend
        var legend = '<div class="donut-legend">';
        for (var i = 0; i < groups.length; i++) {
            var g = groups[i];
            var color = colors[i % colors.length];
            legend += '<div class="donut-legend-item">';
            legend += '<div class="donut-legend-color" style="background:' + color + ';"></div>';
            legend += '<div class="donut-legend-label" title="' + escapeHtml(g.name) + '">' + escapeHtml(g.name) + '</div>';
            legend += '<div class="donut-legend-value">' + g.total + ' (' + g.percent + '%)</div>';
            legend += '</div>';
        }
        legend += '</div>';

        var html = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-pie"></i> {/literal}{$meta.lang['Services Distribution']}{literal}</h3></div>';
        html += '<div class="panel-body">';
        html += '<div class="donut-container">' + svg + legend + '</div>';
        html += '</div></div></div></div>';

        document.getElementById('chart-section').innerHTML = html;
    }

    function renderBarChart(groups) {
        if (groups.length === 0) return;

        var maxVal = groups[0].total;
        if (maxVal === 0) maxVal = 1;

        var colors = ['#337ab7', '#5cb85c', '#5bc0de', '#f0ad4e', '#d9534f', '#9b59b6', '#1abc9c', '#e67e22', '#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#8e44ad', '#16a085', '#c0392b'];

        var html = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-bar"></i> {/literal}{$meta.lang['Group Distribution']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        for (var i = 0; i < groups.length; i++) {
            var g = groups[i];
            var pct = (g.total / maxVal) * 100;
            var color = colors[i % colors.length];
            html += '<div class="hbar-row">';
            html += '<div class="hbar-label" title="' + escapeHtml(g.name) + '">' + escapeHtml(g.name) + '</div>';
            html += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pct + '%; background:' + color + ';">';
            if (pct > 15) {
                html += '<span class="hbar-fill-label">' + g.percent + '%</span>';
            }
            html += '</div></div>';
            html += '<div class="hbar-value">' + g.total + ' (' + g.percent + '%)</div>';
            html += '</div>';
        }

        html += '</div></div></div></div>';
        document.getElementById('chart-section').innerHTML += html;
    }

    function renderTable(groups) {
        if (groups.length === 0) return;

        var html = '<div class="row" style="margin-top:10px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-table"></i> {/literal}{$meta.lang['Group Distribution']}{literal}</h3></div>';
        html += '<div class="panel-body"><div class="table-responsive">';
        html += '<table class="table table-striped table-hover" id="dist-table" style="width:100%; table-layout:fixed;">';
        html += '<thead><tr>';
        html += '<th style="width:30%;">{/literal}{$meta.lang['Group Name']}{literal}</th>';
        html += '<th style="width:80px;">{/literal}{$meta.lang['Products']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Active']}{literal}</th>';
        html += '<th style="width:80px;">{/literal}{$meta.lang['Suspended']}{literal}</th>';
        html += '<th style="width:80px;">{/literal}{$meta.lang['Churned']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Total']}{literal}</th>';
        html += '<th style="width:70px;">{/literal}{$meta.lang['Share']}{literal}</th>';
        html += '<th style="width:90px;">{/literal}{$meta.lang['Active Rate']}{literal}</th>';
        html += '</tr></thead><tbody>';

        for (var i = 0; i < groups.length; i++) {
            var g = groups[i];
            var rowClass = g.hidden ? ' class="text-muted"' : '';
            var badge = g.hidden ? ' <span class="label label-default">{/literal}{$meta.lang['Hidden']}{literal}</span>' : '';

            html += '<tr' + rowClass + '>';
            html += '<td>' + escapeHtml(g.name) + badge + '</td>';
            html += '<td>' + g.products_count + '</td>';
            html += '<td data-order="' + g.active + '"><span class="label label-success">' + g.active + '</span></td>';
            html += '<td data-order="' + g.suspended + '"><span class="label label-warning">' + g.suspended + '</span></td>';
            html += '<td data-order="' + g.churned + '"><span class="label label-danger">' + g.churned + '</span></td>';
            html += '<td data-order="' + g.total + '"><strong>' + g.total + '</strong></td>';
            html += '<td data-order="' + g.percent + '">' + g.percent + '%</td>';
            html += '<td data-order="' + g.active_percent + '">';
            html += '<div style="display:flex; align-items:center; gap:5px;">';
            html += '<div style="flex:1; background:#f5f5f5; border-radius:3px; height:16px; overflow:hidden;">';
            html += '<div style="width:' + g.active_percent + '%; height:100%; background:#5cb85c; border-radius:3px;"></div>';
            html += '</div>';
            html += '<span style="font-size:11px; white-space:nowrap;">' + g.active_percent + '%</span>';
            html += '</div></td>';
            html += '</tr>';
        }

        html += '</tbody></table></div></div></div></div></div>';
        document.getElementById('table-section').innerHTML = html;

        jQuery('#dist-table').DataTable({
            order: [[5, 'desc']],
            paging: false,
            autoWidth: false
        });
    }
});
</script>
{/literal}