<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-file-invoice-dollar"></i> {$meta.lang['Client Revenue']}</h1>
        <p class="text-muted">{$meta.lang['Client Revenue Description']}</p>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="summary-cards"></div>
    <div id="table-section"></div>
</div>

<style>
    .cr-table td,
    .cr-table th {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: middle;
    }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}' + '&ajax=getClientsRevenue';

    function formatMoney(prefix, amount, suffix) {
        var num = parseFloat(amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
        return (prefix || '') + num + (suffix ? ' ' + suffix : '');
    }

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data || response.data.length === 0) {
                if (response.error) showNotification(response.error, 'error');
                document.getElementById('summary-cards').innerHTML =
                    '<div class="row"><div class="col-md-12"><div class="alert alert-info" style="margin-top:15px;"><i class="fa fa-info-circle"></i> {/literal}{$meta.lang['No clients found']}{literal}</div></div></div>';
                return;
            }
            renderAll(response.data);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('Failed to load data', 'error');
        }
    });

    function renderAll(data) {
        var summaryHtml = '';
        var tableHtml = '';

        for (var ci = 0; ci < data.length; ci++) {
            var cur = data[ci];

            // Summary
            summaryHtml += '<div class="row" style="margin-top:10px;">';

            summaryHtml += '<div class="col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #5cb85c;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:26px; font-weight:bold; color:#5cb85c;">' + formatMoney(cur.currency_prefix, cur.total_revenue, cur.currency_suffix) + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-coins"></i> {/literal}{$meta.lang['Total Revenue']}{literal}</div>';
            summaryHtml += '<div style="font-size:11px; color:#aaa;">' + escapeHtml(cur.currency_code) + '</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #337ab7;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:28px; font-weight:bold; color:#337ab7;">' + cur.total_clients + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-users"></i> {/literal}{$meta.lang['Total Clients']}{literal}</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '<div class="col-md-4 col-sm-6">';
            summaryHtml += '<div class="panel panel-default" style="border-top:3px solid #5bc0de;">';
            summaryHtml += '<div class="panel-body text-center">';
            summaryHtml += '<div style="font-size:28px; font-weight:bold; color:#5bc0de;">' + cur.paying_clients + '</div>';
            summaryHtml += '<div class="text-muted" style="margin-top:4px;"><i class="fa fa-credit-card"></i> {/literal}{$meta.lang['Paying Clients']}{literal}</div>';
            summaryHtml += '</div></div></div>';

            summaryHtml += '</div>';

            // Table
            var tableId = 'cr-table' + (ci > 0 ? '-' + ci : '');
            tableHtml += '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
            tableHtml += '<div class="panel panel-default">';
            tableHtml += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-table"></i> {/literal}{$meta.lang['Client Revenue']}{literal} <span class="label label-info">' + escapeHtml(cur.currency_code) + '</span></h3></div>';
            tableHtml += '<div class="panel-body"><div class="table-responsive">';
            tableHtml += '<table class="table table-striped table-hover cr-table" id="' + tableId + '" style="width:100%; table-layout:fixed;">';
            tableHtml += '<thead><tr>';
            tableHtml += '<th style="width:28%;">{/literal}{$meta.lang['Client Name']}{literal}</th>';
            tableHtml += '<th style="width:70px;">{/literal}{$meta.lang['Active']}{literal}</th>';
            tableHtml += '<th style="width:90px;">{/literal}{$meta.lang['Client Since']}{literal}</th>';
            tableHtml += '<th style="width:80px;">{/literal}{$meta.lang['Lifetime']}{literal}</th>';
            tableHtml += '<th style="width:70px;">{/literal}{$meta.lang['Invoices Paid']}{literal}</th>';
            tableHtml += '<th style="width:14%;">{/literal}{$meta.lang['Total Revenue']}{literal}</th>';
            tableHtml += '<th style="width:12%;">{/literal}{$meta.lang['Monthly Value']}{literal}</th>';
            tableHtml += '</tr></thead><tbody>';

            var clients = cur.clients;
            for (var k = 0; k < clients.length; k++) {
                var cl = clients[k];
                var statusLabel = cl.status === 'Active' ? 'label-success' : 'label-default';
                var lifetimeStr = cl.lifetime_months < 1 ? '< 1' : cl.lifetime_months;
                tableHtml += '<tr>';
                tableHtml += '<td title="' + escapeHtml(cl.name) + '">' + escapeHtml(cl.name) + '</td>';
                tableHtml += '<td><span class="label ' + statusLabel + '">' + escapeHtml(cl.status) + '</span></td>';
                tableHtml += '<td>' + cl.datecreated + '</td>';
                tableHtml += '<td data-order="' + cl.lifetime_months + '">' + lifetimeStr + ' {/literal}{$meta.lang['months']}{literal}</td>';
                tableHtml += '<td data-order="' + cl.invoices_paid + '">' + cl.invoices_paid + '</td>';
                tableHtml += '<td data-order="' + cl.revenue + '" style="text-align:right; font-weight:bold; color:#5cb85c;">' + formatMoney(cur.currency_prefix, cl.revenue, cur.currency_suffix) + '</td>';
                tableHtml += '<td data-order="' + cl.monthly_value + '" style="text-align:right; color:#777;">' + formatMoney(cur.currency_prefix, cl.monthly_value, cur.currency_suffix) + '</td>';
                tableHtml += '</tr>';
            }

            tableHtml += '</tbody></table></div></div></div></div></div>';

            (function(tid) {
                setTimeout(function() {
                    jQuery('#' + tid).DataTable({
                        order: [[5, 'desc']],
                        paging: false,
                        autoWidth: false
                    });
                }, 50);
            })(tableId);
        }

        document.getElementById('summary-cards').innerHTML = summaryHtml;
        document.getElementById('table-section').innerHTML = tableHtml;
    }
});
</script>
{/literal}