class PUQTinyMCE {

    renderP = ' ';

    static get toolbox() {
        return {
            title: 'Text Editor TinyMCE',
            icon: '<i class="fas fa-text"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
        this.renderP = undefined;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true,
                bold: true,
                strong: true,
                iframe: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
                em: true,
                del: true,
                blockquote: true,
            }
        };
    }

    render()
    {

        this.renderP = document.createElement('div');
        var id = 'puq'+this.block.id.replace(/[^A-Za-z0-9]/g, "");
        this.renderP.classList.add(id);

        const optionTemplates = generateOptionTemplates('PUQTinyMCE');

        $(this.renderP).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Text Editor TinyMCE</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

<tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td colspan="4" class="fieldarea">
        <textarea name="tinymce" class="`+id+`" id="`+id+`"></textarea>
        </td>
    </tr>
    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(this.renderP).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(this.renderP).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(this.renderP).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(this.renderP).find("[name='style']").val(style);
        if (style === '') {
            $(this.renderP).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(this.renderP).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(this.renderP).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(this.renderP).find("[name='background_color']").val('#FFFFFF');
        }

        if (this.data.disable_background_shadow === true) {
            $(this.renderP).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(this.renderP).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(this.renderP).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(this.renderP).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(this.renderP).find("[name='full_width']").attr('checked', 'checked');
        }

        const text = this.data && this.data.text ? this.data.text : "";
        $(this.renderP).find("[name='tinymce']").text(decodeURIComponent(atob(text)))

        this.initTinymce(id);

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return this.renderP;
    }

    initTinymce(id){
        var tinymceSettings = {
            selector: "textarea."+id,
            height: 500,
            theme: "modern",
            entity_encoding: "raw",
            plugins: "autosave print preview searchreplace autolink directionality visualblocks visualchars fullscreen image link media template code codesample table charmap hr pagebreak nonbreaking anchor insertdatetime advlist lists textcolor wordcount contextmenu colorpicker textpattern help imagetools",
            toolbar: [
                "formatselect | fontselect | fontsizeselect | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent |image media",
                "undo redo | cut copy paste pastetext | searchreplace | subscript superscript | tableformat | hr | charmap | visualchars visualblocks | nonbreaking | fullscreen | code| help| removeformat, link,unlink,blockquote,|,print,|,ltr,rtl,|help,code"
            ],
            image_advtab: true,
            content_css: [
                "//fonts.googleapis.com/css?family=Lato:300,300i,400,400i",
                "//www.tinymce.com/css/codepen.min.css"
            ],
            browser_spellcheck: true,
            convert_urls : false,
            relative_urls : false,
            forced_root_block : "p",
            media_poster: false,
            valid_children: '+body[style]',
            extended_valid_elements: 'style[type]',
            mobile: {
                theme: "mobile",
                plugins: ["autosave", "lists", "autolink"],
                toolbar: ["undo", "bold", "italic", "styleselect"]
            },
            menu: {
                file: {title: "File", items: "preview | print"},
                edit: {title: "Edit", items: "undo redo | cut copy paste pastetext | selectall | searchreplace"},
                view: {title: "View", items: "visualaid visualchars visualblocks | preview fullscreen"},
                insert: {title: "Insert", items: "image anchor link media codesample | charmap hr"},
                format: {title: "Format", items: "bold italic strikethrough underline superscript subscript codeformat | blockformats align | removeformat"},
                table: {title: "Table", items: "inserttable tableprops deletetable | cell row column"},
                help: {title: "Help", items: "help | code"}
            }
        };

        $(function() {
            tinymce.init(tinymceSettings).then(function(editors){
                tinymce.init(tinymceSettings);
            });
        });
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {
        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }
        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        var textarea = $(content).find("[name='tinymce']");
        var id = textarea.attr('class');

        var editors = tinymce.editors;
        for (var i = 0; i < editors.length; i++) {
            if (editors[i].id === id){
                editors[i].remove();
            }
        }
        textarea.hide();
        let text = btoa(encodeURIComponent($(content).find("[name='tinymce']").val()));
        textarea.show();
        this.initTinymce(id);

        return {
            "id": id,
            "width": $(content).find("[name='width']").val().replace(/	/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/	/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/	/g, ""),
            "style": style.replace(/	/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "text": text
        };
    }

    moved(MoveEvent){
        var textarea = $(this.renderP).find("[name='tinymce']");
        var id = textarea.attr('class');

        var editors = tinymce.editors;
        for (var i = 0; i < editors.length; i++) {
            if (editors[i].id === id){
                editors[i].remove();
                this.initTinymce(id);
            }
        }
    }
}
