<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-bar {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        position: relative;
        padding-top: 40px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-bar::before {
        content: '';
        position: absolute;
        top: 58px;
        left: 0;
        right: 0;
        height: 3px;
        background: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-node {
        position: relative;
        flex: 1;
        text-align: center;
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-dot {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        margin: 0 auto 12px auto;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        color: {$data['color_5']};
        position: relative;
        z-index: 2;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-node:hover .{$name}-{$id}-tip-dot {
        transform: scale(1.2);
    }

    .{$name}-{$id} .{$name}-{$id}-tip-date {
        font-size: 0.75rem;
        color: {$data['color_3']};
        font-weight: 600;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-title {
        font-size: 0.85rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-top: 4px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup {
        position: absolute;
        bottom: calc(100% + 12px);
        left: 50%;
        transform: translateX(-50%) translateY(8px);
        background: {$data['color_5']};
        color: {$data['color_2']};
        border: 1px solid {$data['color_4']}44;
        border-radius: 10px;
        padding: 14px 16px;
        width: 220px;
        font-size: 0.8rem;
        line-height: 1.5;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease, transform 0.3s ease;
        z-index: 10;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup::after {
        content: '';
        position: absolute;
        top: 100%;
        left: 50%;
        transform: translateX(-50%);
        border: 8px solid transparent;
        border-top-color: {$data['color_5']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-node:hover .{$name}-{$id}-tip-popup {
        opacity: 1;
        pointer-events: auto;
        transform: translateX(-50%) translateY(0);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-tip-bar { flex-direction: column; padding-top: 0; }
        .{$name}-{$id} .{$name}-{$id}-tip-bar::before { display: none; }
        .{$name}-{$id} .{$name}-{$id}-tip-node { text-align: left; display: flex; align-items: center; gap: 12px; margin-bottom: 16px; }
        .{$name}-{$id} .{$name}-{$id}-tip-dot { margin: 0; flex-shrink: 0; }
        .{$name}-{$id} .{$name}-{$id}-tip-popup { display: none; }
        .{$name}-{$id} .{$name}-{$id}-tip-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-tip-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-tip-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-tip-bar">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-tip-node">
                    {if $item['description'] neq ''}
                        <div class="{$name}-{$id}-tip-popup">{$item['description']}</div>
                    {/if}
                    <div class="{$name}-{$id}-tip-dot" style="background:{if $item['color'] neq ''}{$item['color']}{else}{$data['color_4']}{/if};">
                        {if $item['icon'] neq ''}<i class="{$item['icon']}"></i>{/if}
                    </div>
                    <div>
                        <div class="{$name}-{$id}-tip-date">{$item['date']}</div>
                        <div class="{$name}-{$id}-tip-title">{$item['title']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
