<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-rib-timeline {
        position: relative;
        padding: 20px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 3px;
        height: 100%;
        top: 0;
        background: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item {
        position: relative;
        width: 50%;
        padding: 10px 40px 20px 40px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-left {
        left: 0;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-right {
        left: 50%;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-dot {
        position: absolute;
        width: 16px;
        height: 16px;
        background: {$data['color_4']};
        border-radius: 50%;
        top: 20px;
        border: 3px solid {$data['color_5']};
        box-shadow: 0 0 0 3px {$data['color_4']};
        z-index: 2;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-left .{$name}-{$id}-rib-dot {
        right: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-right .{$name}-{$id}-rib-dot {
        left: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-card {
        background: {$data['color_5']};
        border-radius: 10px;
        overflow: visible;
        box-shadow: 0 2px 10px rgba(0,0,0,0.07);
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-date-ribbon {
        position: absolute;
        top: 12px;
        background: {$data['color_4']};
        color: {$data['color_5']};
        padding: 4px 16px 4px 12px;
        font-size: 0.75rem;
        font-weight: 700;
        clip-path: polygon(0 0, 100% 0, 92% 100%, 0 100%);
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-left .{$name}-{$id}-rib-date-ribbon {
        right: -6px;
        clip-path: polygon(8% 0, 100% 0, 100% 100%, 0 100%);
    }

    .{$name}-{$id} .{$name}-{$id}-rib-item-right .{$name}-{$id}-rib-date-ribbon {
        left: -6px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-body {
        padding: 38px 20px 20px 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-icon {
        color: {$data['color_6']};
        font-size: 1.2rem;
        margin-bottom: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-title {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-rib-line { left: 20px; }
        .{$name}-{$id} .{$name}-{$id}-rib-item { width: 100%; left: 0; padding-left: 50px; text-align: left; }
        .{$name}-{$id} .{$name}-{$id}-rib-item .{$name}-{$id}-rib-dot { left: 12px; right: auto; }
        .{$name}-{$id} .{$name}-{$id}-rib-item .{$name}-{$id}-rib-date-ribbon { left: -6px; clip-path: polygon(0 0, 100% 0, 92% 100%, 0 100%); }
        .{$name}-{$id} .{$name}-{$id}-rib-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-rib-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-rib-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-rib-timeline">
            <div class="{$name}-{$id}-rib-line"></div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-rib-item {if $data['alternate'] && $idx % 2 == 0}{$name}-{$id}-rib-item-left{else}{$name}-{$id}-rib-item-right{/if}">
                    <div class="{$name}-{$id}-rib-dot" {if $item['color'] neq ''}style="background:{$item['color']};box-shadow:0 0 0 3px {$item['color']}"{/if}></div>
                    <div class="{$name}-{$id}-rib-card">
                        {if $item['date'] neq ''}
                            <div class="{$name}-{$id}-rib-date-ribbon" {if $item['color'] neq ''}style="background:{$item['color']}"{/if}>{$item['date']}</div>
                        {/if}
                        <div class="{$name}-{$id}-rib-body">
                            {if $item['icon'] neq ''}
                                <div class="{$name}-{$id}-rib-icon"><i class="{$item['icon']}"></i></div>
                            {/if}
                            <div class="{$name}-{$id}-rib-title">{$item['title']}</div>
                            <div class="{$name}-{$id}-rib-desc">{$item['description']}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
