<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-timeline {
        position: relative;
        padding: 20px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 3px;
        height: 100%;
        top: 0;
        background: {$data['color_4']}44;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item {
        position: relative;
        width: 50%;
        padding: 10px 40px 20px 40px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item-left {
        left: 0;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item-right {
        left: 50%;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-dot {
        position: absolute;
        width: 16px;
        height: 16px;
        background: {$data['color_4']}66;
        border-radius: 50%;
        top: 20px;
        border: 3px solid {$data['color_5']};
        z-index: 2;
        transition: background 0.4s ease, box-shadow 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item:hover .{$name}-{$id}-gray-dot {
        background: {$data['color_4']};
        box-shadow: 0 0 0 3px {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item-left .{$name}-{$id}-gray-dot {
        right: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item-right .{$name}-{$id}-gray-dot {
        left: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card {
        background: {$data['color_5']};
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        filter: grayscale(30%);
        opacity: 0.85;
        transition: filter 0.4s ease, opacity 0.4s ease, box-shadow 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-item:hover .{$name}-{$id}-gray-card {
        filter: grayscale(0%);
        opacity: 1;
        box-shadow: 0 6px 24px rgba(0,0,0,0.1);
    }

    .{$name}-{$id} .{$name}-{$id}-gray-date {
        font-size: 0.85rem;
        color: {$data['color_3']};
        font-weight: 600;
        margin-bottom: 5px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-date i {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-title {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-gray-line { left: 20px; }
        .{$name}-{$id} .{$name}-{$id}-gray-item { width: 100%; left: 0; padding-left: 50px; text-align: left; }
        .{$name}-{$id} .{$name}-{$id}-gray-item .{$name}-{$id}-gray-dot { left: 12px; right: auto; }
        .{$name}-{$id} .{$name}-{$id}-gray-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-gray-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-gray-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-gray-timeline">
            <div class="{$name}-{$id}-gray-line"></div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-gray-item {if $data['alternate'] && $idx % 2 == 0}{$name}-{$id}-gray-item-left{else}{$name}-{$id}-gray-item-right{/if}">
                    <div class="{$name}-{$id}-gray-dot" {if $item['color'] neq ''}style="background:{$item['color']}66"{/if}></div>
                    <div class="{$name}-{$id}-gray-card">
                        {if $item['date'] neq ''}
                            <div class="{$name}-{$id}-gray-date">{if $item['icon'] neq ''}<i class="{$item['icon']}"></i> {/if}{$item['date']}</div>
                        {/if}
                        <div class="{$name}-{$id}-gray-title">{$item['title']}</div>
                        <div class="{$name}-{$id}-gray-desc">{$item['description']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
