<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-list {
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-item {
        display: flex;
        gap: 24px;
        margin-bottom: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-date-col {
        flex: 0 0 140px;
        text-align: right;
        padding-top: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-date {
        font-size: 0.85rem;
        color: {$data['color_3']};
        font-weight: 700;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-indicator {
        flex: 0 0 3px;
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-indicator::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 3px;
        height: 100%;
        background: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card {
        flex: 1;
        background: {$data['color_5']};
        border-left: 4px solid {$data['color_4']};
        padding: 20px 24px;
        box-shadow: 0 1px 6px rgba(0,0,0,0.05);
        transition: border-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card:hover {
        border-left-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-icon {
        display: inline-block;
        color: {$data['color_6']};
        font-size: 1.1rem;
        margin-bottom: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-title {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-brd-item { flex-direction: column; gap: 0; }
        .{$name}-{$id} .{$name}-{$id}-brd-date-col { text-align: left; flex: none; padding-top: 0; padding-bottom: 4px; }
        .{$name}-{$id} .{$name}-{$id}-brd-indicator { display: none; }
        .{$name}-{$id} .{$name}-{$id}-brd-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-brd-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-brd-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-brd-list">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-brd-item">
                    <div class="{$name}-{$id}-brd-date-col">
                        <div class="{$name}-{$id}-brd-date">{$item['date']}</div>
                    </div>
                    <div class="{$name}-{$id}-brd-indicator"></div>
                    <div class="{$name}-{$id}-brd-card" {if $item['color'] neq ''}style="border-left-color:{$item['color']}"{/if}>
                        {if $item['icon'] neq ''}
                            <div class="{$name}-{$id}-brd-icon"><i class="{$item['icon']}"></i></div>
                        {/if}
                        <div class="{$name}-{$id}-brd-title">{$item['title']}</div>
                        <div class="{$name}-{$id}-brd-desc">{$item['description']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
