<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-card {
        background: {$data['color_5']};
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.06);
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-stars {
        margin-bottom: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-stars i {
        color: {$data['color_4']};
        font-size: 1rem;
    }

    .{$name}-{$id} .{$name}-{$id}-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-quote {
        font-size: 1rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 20px;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-quote::before {
        content: "\201C";
        font-size: 3rem;
        color: {$data['color_6']};
        line-height: 0;
        vertical-align: -0.6em;
        margin-right: 5px;
    }

    .{$name}-{$id} .{$name}-{$id}-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-photo {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-author-name {
        font-weight: 600;
        color: {$data['color_1']};
    }

    .{$name}-{$id} .{$name}-{$id}-author-role {
        font-size: 0.85rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-author-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-author-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
