<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card {
        background: {$data['color_5']};
        border: 1px solid {$data['color_6']}44;
        border-radius: 12px;
        padding: 28px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card:hover {
        border-color: {$data['color_6']};
        box-shadow: 0 0 20px {$data['color_6']}33, 0 0 40px {$data['color_6']}11;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-stars {
        margin-bottom: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-stars i {
        color: {$data['color_4']};
        font-size: 0.9rem;
        text-shadow: 0 0 6px {$data['color_4']}66;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-stars i.empty {
        color: {$data['color_6']}44;
        text-shadow: none;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 20px;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-quote::before {
        content: "\201C";
        font-size: 2.5rem;
        color: {$data['color_6']};
        line-height: 0;
        vertical-align: -0.5em;
        margin-right: 4px;
        text-shadow: 0 0 10px {$data['color_6']}66;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-photo {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid {$data['color_6']};
        box-shadow: 0 0 8px {$data['color_6']}44;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 0.95rem;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-neon-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-neon-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-neon-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-neon-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-neon-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-neon-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-neon-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-neon-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-neon-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-neon-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-neon-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-neon-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
