<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-min-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-min-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-min-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-card {
        background: {$data['color_5']};
        padding: 28px 24px;
        border-bottom: 1px solid {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-min-card:last-child {
        border-bottom: none;
    }

    .{$name}-{$id} .{$name}-{$id}-min-stars {
        margin-bottom: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-min-stars i {
        color: {$data['color_4']};
        font-size: 0.85rem;
    }

    .{$name}-{$id} .{$name}-{$id}-min-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-min-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.8;
        margin-bottom: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-min-author {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-min-photo {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-min-name {
        font-weight: 600;
        color: {$data['color_1']};
        font-size: 0.9rem;
    }

    .{$name}-{$id} .{$name}-{$id}-min-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-min-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-min-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-min-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-min-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-min-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-min-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-min-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-min-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-min-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-min-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-min-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-min-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
