<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card {
        background: {$data['color_5']};
        border-radius: 12px;
        padding: 28px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.06);
        transition: box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card:hover {
        box-shadow: 0 8px 28px rgba(0,0,0,0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-gray-author {
        display: flex;
        align-items: center;
        gap: 14px;
        margin-bottom: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-photo {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        object-fit: cover;
        filter: grayscale(100%);
        transition: filter 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card:hover .{$name}-{$id}-gray-photo {
        filter: grayscale(0%);
    }

    .{$name}-{$id} .{$name}-{$id}-gray-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 1rem;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-stars {
        margin-bottom: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-stars i {
        color: {$data['color_4']};
        font-size: 0.85rem;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-quote::before {
        content: "\201C";
        font-size: 2.5rem;
        color: {$data['color_6']};
        line-height: 0;
        vertical-align: -0.5em;
        margin-right: 4px;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-gray-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-gray-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-gray-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-gray-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-gray-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-gray-card">
                    <div class="{$name}-{$id}-gray-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-gray-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-gray-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-gray-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-gray-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-gray-quote">{$item['text']}</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
