<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card {
        background: linear-gradient(135deg, {$data['color_5']} 0%, {$data['color_6']}15 100%);
        border-radius: 16px;
        padding: 32px;
        transition: background 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card:hover {
        background: linear-gradient(135deg, {$data['color_6']}15 0%, {$data['color_5']} 100%);
    }

    .{$name}-{$id} .{$name}-{$id}-fade-top {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-photo {
        width: 52px;
        height: 52px;
        border-radius: 50%;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 1rem;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-stars i {
        color: {$data['color_4']};
        font-size: 0.85rem;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-quote::before {
        content: "\201C";
        font-size: 2rem;
        color: {$data['color_6']};
        line-height: 0;
        vertical-align: -0.4em;
        margin-right: 4px;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-fade-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-fade-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-fade-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-fade-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-fade-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-fade-card">
                    <div class="{$name}-{$id}-fade-top">
                        <div class="{$name}-{$id}-fade-author">
                            {if $item['photo_url'] neq ''}
                                <img class="{$name}-{$id}-fade-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                            {/if}
                            <div>
                                <div class="{$name}-{$id}-fade-name">{$item['name']}</div>
                                <div class="{$name}-{$id}-fade-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                            </div>
                        </div>
                        {if $data['show_rating'] && $item['rating']}
                            <div class="{$name}-{$id}-fade-stars">
                                {for $s=1 to 5}
                                    <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                                {/for}
                            </div>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-fade-quote">{$item['text']}</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
