<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card {
        background: {$data['color_5']};
        border-radius: 20px;
        padding: 32px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        text-align: center;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 12px 32px rgba(0,0,0,0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-photo {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        object-fit: cover;
        margin: 0 auto 16px auto;
        display: block;
        border: 3px solid {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-stars {
        margin-bottom: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-stars i {
        color: {$data['color_4']};
        font-size: 0.9rem;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 20px;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 1.05rem;
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-cards-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-cards-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-cards-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-cards-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-cards-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-cards-card">
                    {if $item['photo_url'] neq ''}
                        <img class="{$name}-{$id}-cards-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                    {/if}
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-cards-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-cards-quote">{$item['text']}</div>
                    <h4 class="{$name}-{$id}-cards-name">{$item['name']}</h4>
                    <p class="{$name}-{$id}-cards-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</p>
                </div>
            {/foreach}
        </div>
    </div>
</div>
