<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-rib-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
        gap: 24px;
        justify-items: center;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-card {
        position: relative;
        background: {$data['color_6']};
        border-radius: 12px;
        overflow: visible;
        width: 100%;
        max-width: 300px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        padding-top: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-img {
        width: 100%;
        height: 260px;
        object-fit: cover;
        display: block;
        border-radius: 12px 12px 0 0;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-name-tag {
        position: absolute;
        top: 240px;
        left: -8px;
        background: {$data['color_3']};
        color: {$data['color_4']};
        padding: 8px 20px 8px 16px;
        font-weight: 700;
        font-size: 1rem;
        z-index: 3;
        clip-path: polygon(0 0, 100% 0, 92% 100%, 0 100%);
    }

    .{$name}-{$id} .{$name}-{$id}-rib-body {
        padding: 28px 20px 20px 20px;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 8px 0;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-weight: 600;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-bio {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.6;
        margin: 0 0 14px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-social {
        display: flex;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 34px;
        height: 34px;
        border-radius: 8px;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 14px;
        transition: background 0.2s, color 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-rib-grid {
            grid-template-columns: repeat(auto-fill, minmax(230px, 1fr));
            gap: 16px;
        }
        .{$name}-{$id} .{$name}-{$id}-rib-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-rib-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-rib-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-rib-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-rib-card">
                    <img class="{$name}-{$id}-rib-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-rib-name-tag">{$member['member_name']}</div>
                    <div class="{$name}-{$id}-rib-body">
                        <p class="{$name}-{$id}-rib-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-rib-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-rib-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
