<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-min-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-min-header {
        text-align: left;
        font-size: 2.2rem;
        font-weight: 300;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
        line-height: 1.3;
    }

    .{$name}-{$id} .{$name}-{$id}-min-list {
        display: flex;
        flex-direction: column;
    }

    .{$name}-{$id} .{$name}-{$id}-min-item {
        display: flex;
        align-items: center;
        gap: 24px;
        padding: 20px 0;
        border-bottom: 1px solid rgba(0,0,0,0.08);
    }

    .{$name}-{$id} .{$name}-{$id}-min-item:last-child {
        border-bottom: none;
    }

    .{$name}-{$id} .{$name}-{$id}-min-avatar {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        object-fit: cover;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-info {
        flex: 1;
        min-width: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-name {
        font-size: 1.1rem;
        font-weight: 600;
        color: {$data['color_1']};
        margin: 0 0 2px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-position {
        font-size: 0.85rem;
        color: {$data['color_2']};
        margin: 0 0 6px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-bio {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.5;
        margin: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-social {
        display: flex;
        gap: 6px;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-min-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        border-radius: 6px;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 14px;
        transition: opacity 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-min-social a:hover {
        opacity: 0.7;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-min-item {
            flex-wrap: wrap;
            gap: 12px;
        }
        .{$name}-{$id} .{$name}-{$id}-min-social {
            width: 100%;
            padding-left: 104px;
        }
        .{$name}-{$id} .{$name}-{$id}-min-header {
            font-size: 1.6rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-min-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-min-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-min-list">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-min-item">
                    <img class="{$name}-{$id}-min-avatar" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-min-info">
                        <h4 class="{$name}-{$id}-min-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-min-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-min-bio">{$member['member_bio']}</p>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-min-social">
                        {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                        {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                        {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                        {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                        {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                        {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
