<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-gray-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
        gap: 24px;
        justify-items: center;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card {
        background: {$data['color_6']};
        border-radius: 12px;
        overflow: hidden;
        width: 100%;
        max-width: 300px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.06);
        transition: box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card:hover {
        box-shadow: 0 8px 28px rgba(0,0,0,0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-gray-img {
        width: 100%;
        height: 280px;
        object-fit: cover;
        display: block;
        filter: grayscale(100%);
        transition: filter 0.5s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-card:hover .{$name}-{$id}-gray-img {
        filter: grayscale(0%);
    }

    .{$name}-{$id} .{$name}-{$id}-gray-body {
        padding: 20px;
        text-align: center;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-name {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-position {
        font-size: 0.85rem;
        color: {$data['color_2']};
        margin: 0 0 10px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-bio {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.6;
        margin: 0 0 14px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-social {
        display: flex;
        justify-content: center;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 34px;
        height: 34px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 14px;
        transition: background 0.2s, color 0.2s, transform 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-gray-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
        transform: scale(1.1);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-gray-grid {
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 16px;
        }
        .{$name}-{$id} .{$name}-{$id}-gray-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-gray-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-gray-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-gray-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-gray-card">
                    <img class="{$name}-{$id}-gray-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-gray-body">
                        <h4 class="{$name}-{$id}-gray-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-gray-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-gray-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-gray-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
