<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 1.5rem 0;
        color: {$data['header_text_color']};
    }

    /* Tabs mode - card pills */
    .{$name}-{$id} .{$name}-{$id}-cards-tabs-nav {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        justify-content: center;
        margin-bottom: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-tab-btn {
        padding: 10px 22px;
        cursor: pointer;
        font-weight: 600;
        color: {$data['color_1']};
        background: {$data['color_2']};
        border: 2px solid {$data['color_2']};
        border-radius: 30px;
        transition: all 0.3s ease;
        font-size: 0.95rem;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.06);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-tab-btn:hover {
        background: {$data['color_3']};
        border-color: {$data['color_6']};
        color: {$data['color_6']};
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-tab-btn-active {
        background: {$data['color_6']};
        border-color: {$data['color_6']};
        color: #fff;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-tab-content {
        display: none;
        background: {$data['color_5']};
        color: {$data['color_4']};
        border-radius: 14px;
        padding: 28px 24px;
        text-align: left;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
        animation: {$name}-{$id}-cardsFadeIn 0.3s ease;
        font-size: 1rem;
        line-height: 1.7;
    {if $data['margin_bottom'] neq ''}
        margin-bottom: {$data['margin_bottom']};
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-cards-tab-content-active {
        display: block;
    }

    /* Accordion mode - card items */
    .{$name}-{$id} .{$name}-{$id}-cards-acc-list {
        display: flex;
        flex-direction: column;
        gap: 12px;
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-card {
        background: {$data['color_5']};
        border: 1px solid {$data['color_2']};
        border-radius: 14px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-header {
        background: {$data['color_2']};
        padding: 16px 24px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
        transition: background 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-header:hover {
        background: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-title {
        color: {$data['color_1']};
        font-weight: 700;
        font-size: 1.05rem;
        flex: 1;
        text-align: left;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-icon-btn {
        width: 28px;
        height: 28px;
        min-width: 28px;
        border-radius: 50%;
        background-color: {$data['color_6']};
        display: flex;
        align-items: center;
        justify-content: center;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-icon-btn i {
        color: #fff;
        font-size: 0.7rem;
        line-height: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-icon-open {
        transform: rotate(45deg);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-body {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-acc-body-inner {
        padding: 20px 24px;
        border-top: 1px solid {$data['color_2']};
        color: {$data['color_4']};
        font-size: 0.95rem;
        line-height: 1.7;
        text-align: left;
    }

    @keyframes {$name}-{$id}-cardsFadeIn {
        from { opacity: 0; transform: translateY(6px); }
        to { opacity: 1; transform: translateY(0); }
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-cards-header {
            font-size: 1.4rem;
        }

        .{$name}-{$id} .{$name}-{$id}-cards-tab-btn {
            padding: 8px 16px;
            font-size: 0.85rem;
        }

        .{$name}-{$id} .{$name}-{$id}-cards-tab-content {
            padding: 20px 16px;
        }

        .{$name}-{$id} .{$name}-{$id}-cards-acc-header {
            padding: 14px 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-cards-acc-body-inner {
            padding: 16px 18px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-cards-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-cards-header">{$data['header']}</h2>
        {/if}

        {if $data['mode'] eq 'tabs'}
            <div class="{$name}-{$id}-cards-tabs-nav">
                {foreach $data['items'] as $idx => $item}
                    <button class="{$name}-{$id}-cards-tab-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-cards-tab-btn-active{/if}" onclick="puqTabCards{$id}({$idx})">{$item['title']}</button>
                {/foreach}
            </div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-cards-tab-content {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-cards-tab-content-active{/if}" id="{$name}-{$id}-cards-tab-{$idx}">{$item['content']}</div>
            {/foreach}
        {else}
            <div class="{$name}-{$id}-cards-acc-list">
                {foreach $data['items'] as $idx => $item}
                    <div class="{$name}-{$id}-cards-acc-card">
                        <div class="{$name}-{$id}-cards-acc-header" onclick="puqAccCards{$id}({$idx})">
                            <span class="{$name}-{$id}-cards-acc-title">{$item['title']}</span>
                            <div class="{$name}-{$id}-cards-acc-icon-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-cards-acc-icon-open{/if}" id="{$name}-{$id}-cards-acc-icon-{$idx}">
                                <i class="fas fa-plus"></i>
                            </div>
                        </div>
                        <div class="{$name}-{$id}-cards-acc-body" id="{$name}-{$id}-cards-acc-body-{$idx}" {if $idx == ($data['default_open']|default:0)}style="max-height:2000px"{/if}>
                            <div class="{$name}-{$id}-cards-acc-body-inner">{$item['content']}</div>
                        </div>
                    </div>
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
{if $data['mode'] eq 'tabs'}
function puqTabCards{$id}(idx) {
    var btns = document.querySelectorAll('.{$name}-{$id}-cards-tab-btn');
    var contents = document.querySelectorAll('.{$name}-{$id}-cards-tab-content');
    for (var i = 0; i < btns.length; i++) {
        btns[i].classList.remove('{$name}-{$id}-cards-tab-btn-active');
        contents[i].classList.remove('{$name}-{$id}-cards-tab-content-active');
    }
    btns[idx].classList.add('{$name}-{$id}-cards-tab-btn-active');
    document.getElementById('{$name}-{$id}-cards-tab-' + idx).classList.add('{$name}-{$id}-cards-tab-content-active');
}
{else}
function puqAccCards{$id}(idx) {
    var bodies = document.querySelectorAll('.{$name}-{$id}-cards-acc-body');
    var icons = document.querySelectorAll('.{$name}-{$id}-cards-acc-icon-btn');

    for (var i = 0; i < bodies.length; i++) {
        var itemIdx = bodies[i].id.split('-').pop();
        if (parseInt(itemIdx) === idx) {
            if (bodies[i].style.maxHeight) {
                bodies[i].style.maxHeight = null;
                icons[i].classList.remove('{$name}-{$id}-cards-acc-icon-open');
            } else {
                bodies[i].style.maxHeight = bodies[i].scrollHeight + 'px';
                icons[i].classList.add('{$name}-{$id}-cards-acc-icon-open');
            }
        } else {
            bodies[i].style.maxHeight = null;
            icons[i].classList.remove('{$name}-{$id}-cards-acc-icon-open');
        }
    }
}
{/if}
</script>
