<style>
    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-slider {
        position: relative;
        z-index: 2;
        overflow: hidden;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-track {
        display: flex;
        align-items: center;
        width: calc(140px * {$data['logos_count']});
        animation: {$name}-{$id}-scroll-{$data['scroll']} {$data['scroll_speed']}s linear infinite;
    }

    .{$name}-{$id} .{$name}-{$id}-slider:hover .{$name}-{$id}-track {
        animation-play-state: paused;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        flex-shrink: 0;
        width: 140px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 10px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-ring {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        border: 2px solid {$data['color_6']}25;
        background: {$data['color_5']};
        display: flex;
        align-items: center;
        justify-content: center;
        transition: border-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-ring:hover {
        border-color: {$data['color_1']};
        transform: scale(1.1);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-ring img {
        width: 50px;
        height: 50px;
        object-fit: contain;
    }

    .{$name}-{$id} .{$name}-{$id}-ring a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    @keyframes {$name}-{$id}-scroll-left {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(-50%);
        }
    }

    @keyframes {$name}-{$id}-scroll-right {
        0% {
            transform: translateX(-50%);
        }
        100% {
            transform: translateX(0);
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-slider">
        <div class="{$name}-{$id}-track">
            {foreach $data['logos'] as $logo}
                <div class="{$name}-{$id}-item">
                    <div class="{$name}-{$id}-ring">
                        {if $logo['logo_url'] neq ''}
                            <a href="{$logo['logo_url']}" target="_blank"><img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" /></a>
                        {else}
                            <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                        {/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
