<style>
    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-slider {
        position: relative;
        z-index: 2;
        overflow: hidden;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-track {
        display: flex;
        width: calc(220px * {$data['logos_count']});
        animation: {$name}-{$id}-scroll-{$data['scroll']} {$data['scroll_speed']}s linear infinite;
    }

    .{$name}-{$id} .{$name}-{$id}-slider:hover .{$name}-{$id}-track {
        animation-play-state: paused;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        flex-shrink: 0;
        width: 220px;
        padding: 0 10px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-card {
        background: {$data['color_5']};
        border-radius: 12px;
        padding: 20px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
    }

    .{$name}-{$id} .{$name}-{$id}-card img {
        width: 140px;
        height: 50px;
        object-fit: contain;
    }

    .{$name}-{$id} .{$name}-{$id}-card-name {
        margin-top: 8px;
        font-size: 0.75rem;
        font-weight: 600;
        color: {$data['color_1']};
        letter-spacing: 0.5px;
        text-align: center;
    }

    .{$name}-{$id} .{$name}-{$id}-card a {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-decoration: none;
    }

    @keyframes {$name}-{$id}-scroll-left {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(-50%);
        }
    }

    @keyframes {$name}-{$id}-scroll-right {
        0% {
            transform: translateX(-50%);
        }
        100% {
            transform: translateX(0);
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-slider">
        <div class="{$name}-{$id}-track">
            {foreach $data['logos'] as $logo}
                <div class="{$name}-{$id}-item">
                    <div class="{$name}-{$id}-card">
                        {if $logo['logo_url'] neq ''}
                            <a href="{$logo['logo_url']}" target="_blank">
                                <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                                <span class="{$name}-{$id}-card-name">{$logo['logo_name']}</span>
                            </a>
                        {else}
                            <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                            <span class="{$name}-{$id}-card-name">{$logo['logo_name']}</span>
                        {/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
