<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 1.5rem 0;
        padding: 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-list {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-item {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-item:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-puq-question {
        background-color: {$data['color_2']};
        cursor: pointer;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 24px;
        transition: background-color 0.3s ease;
        border-radius: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-question:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-question-text {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.15rem;
        font-weight: 700;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-icon {
        color: {$data['color_1']};
        font-size: 1rem;
        flex-shrink: 0;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-answer {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
        border-bottom-left-radius: 10px;
        border-bottom-right-radius: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-answer-text {
        color: {$data['color_4']};
        padding: 24px;
        text-align: left;
        font-size: 1rem;
        line-height: 1.7;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-puq-header {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-question {
            padding: 14px 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-question-text {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-answer-text {
            padding: 18px;
            font-size: 0.95rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-puq-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-puq-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-puq-list">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-puq-item">
                    <div class="{$name}-{$id}-puq-question" onclick="puqqapuq{$id}({$key})">
                        <div class="{$name}-{$id}-puq-question-text">{$value['question']}</div>
                        <i class="fas fa-plus {$name}-{$id}-puq-icon" id="{$name}-{$id}-puq-icon-{$key}"></i>
                    </div>
                    <div class="{$name}-{$id}-puq-answer" id="{$name}-{$id}-puq-answer-{$key}">
                        <div class="{$name}-{$id}-puq-answer-text">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqapuq{$id}(key) {
        var items = document.querySelectorAll('.{$name}-{$id}-puq-answer');
        var icons = document.querySelectorAll('.{$name}-{$id}-puq-icon');

        for (var i = 0; i < items.length; i++) {
            var itemKey = items[i].id.split('-').pop();
            if (parseInt(itemKey) === key) {
                if (items[i].style.maxHeight) {
                    items[i].style.maxHeight = null;
                    icons[i].classList.remove('fa-minus');
                    icons[i].classList.add('fa-plus');
                } else {
                    items[i].style.maxHeight = items[i].scrollHeight + 'px';
                    icons[i].classList.remove('fa-plus');
                    icons[i].classList.add('fa-minus');
                }
            } else {
                items[i].style.maxHeight = null;
                icons[i].classList.remove('fa-minus');
                icons[i].classList.add('fa-plus');
            }
        }
    }
</script>