<style>
    .{$name}-{$id}-timeline- {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id}-timeline-container {
        position: relative;
        z-index: 2;
        display: inline-block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
    }

    .{$name}-{$id}-timeline-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0 2.5rem 0;
        color: {$data['header_text_color']};
    }

    /* --- Timeline wrapper --- */
    .{$name}-{$id}-timeline-track {
        position: relative;
        padding: 20px 0;
    }

    /* Vertical centre line */
    .{$name}-{$id}-timeline-track::before {
        content: "";
        position: absolute;
        top: 0;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 2px;
        background-color: {$data['color_6']};
    }

    /* --- Single item row --- */
    .{$name}-{$id}-timeline-item {
        position: relative;
        display: flex;
        align-items: flex-start;
        margin-bottom: 30px;
        width: 100%;
    }

    .{$name}-{$id}-timeline-item:last-child {
        margin-bottom: 0;
    }

    /* Odd items: card LEFT, spacer RIGHT */
    .{$name}-{$id}-timeline-item-odd {
        flex-direction: row;
    }

    /* Even items: spacer LEFT, card RIGHT */
    .{$name}-{$id}-timeline-item-even {
        flex-direction: row-reverse;
    }

    /* Card side (always the first child in flex order) */
    .{$name}-{$id}-timeline-side {
        width: calc(50% - 24px);
        flex-shrink: 0;
    }

    /* Spacer side */
    .{$name}-{$id}-timeline-spacer {
        width: calc(50% - 24px);
        flex-shrink: 0;
    }

    /* --- Node circle on the line --- */
    .{$name}-{$id}-timeline-node {
        position: absolute;
        left: 50%;
        top: 12px;
        transform: translateX(-50%);
        width: 32px;
        height: 32px;
        border-radius: 50%;
        background-color: {$data['color_6']};
        color: {$data['color_5']};
        font-size: 0.8rem;
        font-weight: 700;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 3;
        box-shadow: 0 0 0 4px rgba(0, 0, 0, 0.06);
        flex-shrink: 0;
    }

    /* --- Card --- */
    .{$name}-{$id}-timeline-card {
        position: relative;
        background-color: {$data['color_2']};
        border-radius: 10px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.12);
        overflow: hidden;
    }

    /* Triangle pointer -- odd items: card on LEFT, pointer faces RIGHT toward centre */
    .{$name}-{$id}-timeline-item-odd .{$name}-{$id}-timeline-card::after {
        content: "";
        position: absolute;
        top: 16px;
        right: -10px;
        border-width: 10px;
        border-style: solid;
        border-color: transparent transparent transparent {$data['color_2']};
    }

    /* Triangle pointer -- even items: card on RIGHT, pointer faces LEFT toward centre */
    .{$name}-{$id}-timeline-item-even .{$name}-{$id}-timeline-card::after {
        content: "";
        position: absolute;
        top: 16px;
        left: -10px;
        border-width: 10px;
        border-style: solid;
        border-color: transparent {$data['color_2']} transparent transparent;
    }

    /* --- Question header inside card --- */
    .{$name}-{$id}-timeline-q {
        padding: 14px 18px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
        transition: background-color 0.2s ease;
    }

    .{$name}-{$id}-timeline-q:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id}-timeline-q-text {
        color: {$data['color_1']};
        font-weight: 600;
        font-size: 1.1rem;
        flex: 1;
        text-align: left;
    }

    .{$name}-{$id}-timeline-icon {
        color: {$data['color_1']};
        font-size: 0.85rem;
        flex-shrink: 0;
        transition: transform 0.2s ease;
    }

    /* --- Answer inside card --- */
    .{$name}-{$id}-timeline-a {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1),
                    padding 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id}-timeline-a-text {
        color: {$data['color_4']};
        padding: 16px 18px;
        font-size: 1rem;
        line-height: 1.6;
        text-align: left;
    }

    /* ====== Responsive: mobile (<768px) ====== */
    @media (max-width: 768px) {
        .{$name}-{$id}-timeline-track::before {
            left: 16px;
            transform: none;
        }

        .{$name}-{$id}-timeline-item,
        .{$name}-{$id}-timeline-item-odd,
        .{$name}-{$id}-timeline-item-even {
            flex-direction: row;
        }

        .{$name}-{$id}-timeline-node {
            position: relative;
            left: auto;
            top: auto;
            transform: none;
            margin-right: 16px;
            flex-shrink: 0;
        }

        .{$name}-{$id}-timeline-spacer {
            display: none;
        }

        .{$name}-{$id}-timeline-side {
            width: 100%;
            flex: 1;
            min-width: 0;
        }

        /* All pointers face LEFT on mobile */
        .{$name}-{$id}-timeline-item-odd .{$name}-{$id}-timeline-card::after {
            right: auto;
            left: -10px;
            border-color: transparent {$data['color_2']} transparent transparent;
        }
    }
</style>

<div class="{$name}-{$id}-timeline-">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-timeline-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-timeline-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-timeline-track">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-timeline-item {if $key % 2 != 0}{$name}-{$id}-timeline-item-odd{else}{$name}-{$id}-timeline-item-even{/if}">
                    <div class="{$name}-{$id}-timeline-side">
                        <div class="{$name}-{$id}-timeline-card">
                            <div class="{$name}-{$id}-timeline-q" onclick="puqqatimeline{$id}({$key})">
                                <span class="{$name}-{$id}-timeline-q-text">{$value['question']}</span>
                                <i class="fas fa-plus {$name}-{$id}-timeline-icon"></i>
                            </div>
                            <div class="{$name}-{$id}-timeline-a">
                                <div class="{$name}-{$id}-timeline-a-text">{$value['answer']}</div>
                            </div>
                        </div>
                    </div>
                    <div class="{$name}-{$id}-timeline-node">{$key}</div>
                    <div class="{$name}-{$id}-timeline-spacer"></div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqatimeline{$id}(item) {
        var answers{$id} = document.getElementsByClassName("{$name}-{$id}-timeline-a");
        var icons{$id} = document.getElementsByClassName("{$name}-{$id}-timeline-icon");

        for (var i = 0; i < answers{$id}.length; i++) {
            if (i + 1 === item) {
                if (answers{$id}[i].style.maxHeight) {
                    answers{$id}[i].style.maxHeight = null;
                    icons{$id}[i].classList.remove("fa-minus");
                    icons{$id}[i].classList.add("fa-plus");
                } else {
                    answers{$id}[i].style.maxHeight = answers{$id}[i].scrollHeight + "px";
                    icons{$id}[i].classList.remove("fa-plus");
                    icons{$id}[i].classList.add("fa-minus");
                }
            } else {
                answers{$id}[i].style.maxHeight = null;
                icons{$id}[i].classList.remove("fa-minus");
                icons{$id}[i].classList.add("fa-plus");
            }
        }
    }
</script>
